/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativesScreen;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.amount.ActionButton;
import com.refinedmods.refinedstorage.common.support.amount.ActionIcon;
import com.refinedmods.refinedstorage.common.support.amount.AmountOperations;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public abstract class AbstractAmountScreen<T extends AbstractContainerMenu, N extends Number>
extends AbstractBaseScreen<T> {
    private static final MutableComponent RESET_TEXT = IdentifierUtil.createTranslation("gui", "configure_amount.reset");
    private static final MutableComponent CANCEL_TEXT = Component.translatable((String)"gui.cancel");
    private static final int INCREMENT_BUTTON_WIDTH = 30;
    private static final int ACTION_BUTTON_HEIGHT = 20;
    private static final int ACTION_BUTTON_WIDTH = 58;
    private static final int ACTION_BUTTON_SPACING = 20;
    @Nullable
    protected ActionButton confirmButton;
    @Nullable
    protected ActionButton cancelButton;
    @Nullable
    protected EditBox amountField;
    @Nullable
    private final Screen parent;
    private final AmountScreenConfiguration<N> configuration;
    private final AmountOperations<N> amountOperations;

    protected AbstractAmountScreen(T containerMenu, @Nullable Screen parent, Inventory playerInventory, Component title, AmountScreenConfiguration<N> configuration, AmountOperations<N> amountOperations) {
        super(containerMenu, playerInventory, title);
        this.parent = parent;
        this.configuration = configuration;
        this.amountOperations = amountOperations;
    }

    @Override
    protected void init() {
        super.init();
        if (this.configuration.isActionButtonsEnabled()) {
            this.addActionButtons();
        }
        this.addAmountField();
        this.addIncrementButtons();
    }

    private void addActionButtons() {
        Vector3f pos = this.configuration.getActionButtonsStartPosition();
        if (this.configuration.isHorizontalActionButtons()) {
            int spacing = 3;
            this.addCancelButton((int)pos.x, (int)pos.y);
            Button resetButton = this.addResetButton((int)pos.x + Objects.requireNonNull(this.cancelButton).getWidth() + 3, (int)pos.y);
            this.addConfirmButton((int)pos.x + this.cancelButton.getWidth() + 3 + resetButton.getWidth() + 3, (int)pos.y);
        } else {
            int spacing = 24;
            this.addResetButton((int)pos.x, (int)pos.y);
            this.addConfirmButton((int)pos.x, (int)pos.y + 24);
            this.addCancelButton((int)pos.x, (int)pos.y + 48);
        }
    }

    private Button addResetButton(int x, int y) {
        int width = this.configuration.isHorizontalActionButtons() ? this.font.width((FormattedText)RESET_TEXT) + 20 + 12 : 58;
        ActionButton button = new ActionButton(this.leftPos + x, this.topPos + y, width, 20, (Component)RESET_TEXT, btn -> this.reset());
        button.setIcon(ActionIcon.RESET);
        return (Button)this.addRenderableWidget((GuiEventListener)button);
    }

    private void addConfirmButton(int x, int y) {
        int width = this.configuration.isHorizontalActionButtons() ? this.font.width((FormattedText)this.configuration.getConfirmButtonText()) + 20 + 12 : 58;
        ActionButton button = new ActionButton(this.leftPos + x, this.topPos + y, width, 20, this.configuration.getConfirmButtonText(), btn -> this.tryConfirmAndCloseToParent());
        button.setIcon(this.getConfirmButtonIcon());
        this.confirmButton = (ActionButton)this.addRenderableWidget((GuiEventListener)button);
    }

    @Nullable
    protected ActionIcon getConfirmButtonIcon() {
        return ActionIcon.SET;
    }

    private void addCancelButton(int x, int y) {
        int width = this.configuration.isHorizontalActionButtons() ? this.font.width((FormattedText)CANCEL_TEXT) + 20 + 12 : 58;
        ActionButton button = new ActionButton(this.leftPos + x, this.topPos + y, width, 20, (Component)CANCEL_TEXT, btn -> this.close());
        button.setIcon(ActionIcon.CANCEL);
        this.cancelButton = (ActionButton)this.addRenderableWidget((GuiEventListener)button);
    }

    private void addAmountField() {
        Vector3f pos = this.configuration.getAmountFieldPosition();
        String originalValue = this.amountField != null ? this.amountField.getValue() : null;
        int n = this.leftPos + (int)pos.x();
        int n2 = this.topPos + (int)pos.y();
        int n3 = this.configuration.getAmountFieldWidth() - 6;
        Objects.requireNonNull(this.font);
        this.amountField = new EditBox(this.font, n, n2, n3, 9, (Component)Component.empty());
        this.amountField.setBordered(false);
        this.amountField.setTextColor(0xFFFFFF);
        if (originalValue != null) {
            this.amountField.setValue(originalValue);
            this.onAmountFieldChanged();
        } else if (this.configuration.getInitialAmount() != null) {
            this.updateAmount(this.configuration.getInitialAmount());
        }
        this.amountField.setVisible(true);
        this.amountField.setCanLoseFocus(this instanceof AlternativesScreen);
        this.amountField.setFocused(true);
        this.amountField.setResponder(value -> this.onAmountFieldChanged());
        this.setFocused((GuiEventListener)this.amountField);
        this.addRenderableWidget((GuiEventListener)this.amountField);
    }

    protected final void updateAmount(N amount) {
        if (this.amountField == null) {
            return;
        }
        this.amountField.setValue(this.amountOperations.format(amount));
    }

    protected void onAmountFieldChanged() {
        if (this.amountField == null) {
            return;
        }
        boolean valid = this.getAndValidateAmount().isPresent();
        if (this.confirmButton != null) {
            this.confirmButton.active = valid;
            this.confirmButton.setIcon(valid ? this.getConfirmButtonIcon() : ActionIcon.ERROR);
        } else {
            this.tryConfirm();
        }
        this.amountField.setTextColor(valid ? 0xFFFFFF : 0xFF5555);
    }

    private void addIncrementButtons() {
        Vector3f incrementsTopPos = this.configuration.getIncrementsTopStartPosition();
        this.addIncrementButtons(this.configuration.getIncrementsTop(), this.leftPos + (int)incrementsTopPos.x, this.topPos + (int)incrementsTopPos.y);
        Vector3f incrementsBottomPos = this.configuration.getIncrementsBottomStartPosition();
        this.addIncrementButtons(this.configuration.getIncrementsBottom(), this.leftPos + (int)incrementsBottomPos.x, this.topPos + (int)incrementsBottomPos.y);
    }

    private void addIncrementButtons(int[] increments, int x, int y) {
        for (int i = 0; i < increments.length; ++i) {
            int increment = increments[i];
            int xx = x + 33 * i;
            this.addRenderableWidget((GuiEventListener)this.createIncrementButton(xx, y, increment));
        }
    }

    protected abstract boolean confirm(N var1);

    private Button createIncrementButton(int x, int y, int increment) {
        MutableComponent text = Component.literal((String)((increment > 0 ? "+" : "") + increment));
        return Button.builder((Component)text, btn -> this.changeAmount(increment)).pos(x, y).size(30, 20).build();
    }

    private void changeAmount(int delta) {
        if (this.amountField == null) {
            return;
        }
        this.getAndValidateAmount().ifPresentOrElse(oldAmount -> {
            int correctedDelta = this.correctDelta(oldAmount, delta);
            Number newAmount = this.amountOperations.changeAmount((Number)oldAmount, correctedDelta, (Number)this.configuration.getMinAmount(), (Number)this.configuration.getMaxAmount());
            this.updateAmount(newAmount);
        }, () -> this.updateAmount(this.amountOperations.changeAmount(null, delta, this.configuration.getMinAmount(), this.configuration.getMaxAmount())));
    }

    private int correctDelta(N oldAmount, int delta) {
        if (((Number)oldAmount).intValue() == 1 && delta > 1) {
            return delta - 1;
        }
        return delta;
    }

    public boolean mouseScrolled(double x, double y, double z, double delta) {
        if (delta > 0.0) {
            this.changeAmount(1);
        } else {
            this.changeAmount(-1);
        }
        return super.mouseScrolled(x, y, z, delta);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.amountField != null && this.amountField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.tryClose(key)) {
            return true;
        }
        if (this.amountField != null && (key == 257 || key == 335) && this.amountField.isFocused()) {
            this.tryConfirmAndCloseToParent();
            return true;
        }
        if (this.amountField != null && (this.amountField.keyPressed(key, scanCode, modifiers) || this.amountField.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    protected final boolean tryClose(int key) {
        if (key == 256) {
            this.close();
            return true;
        }
        return false;
    }

    protected void reset() {
        if (this.amountField == null || this.configuration.getResetAmount() == null) {
            return;
        }
        this.updateAmount(this.configuration.getResetAmount());
    }

    private void tryConfirm() {
        this.getAndValidateAmount().ifPresent(this::confirm);
    }

    private void tryConfirmAndCloseToParent() {
        this.getAndValidateAmount().ifPresent(value -> {
            if (this.confirm(value)) {
                this.tryCloseToParent();
            }
        });
    }

    private boolean tryCloseToParent() {
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
            return true;
        }
        return false;
    }

    public final void close() {
        if (!this.beforeClose()) {
            return;
        }
        if (!this.tryCloseToParent()) {
            this.onClose();
        }
    }

    protected boolean beforeClose() {
        return true;
    }

    protected final Optional<N> getAndValidateAmount() {
        if (this.amountField == null) {
            return Optional.empty();
        }
        return this.amountOperations.parse(this.amountField.getValue()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.configuration.getMinAmount(), (Number)this.configuration.getMaxAmount()));
    }

    protected static class DefaultDummyContainerMenu
    extends AbstractContainerMenu {
        protected DefaultDummyContainerMenu() {
            super(null, 0);
        }

        public ItemStack quickMoveStack(Player player, int i) {
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player player) {
            return true;
        }
    }
}

