/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public class SchedulingModeContainer {
    private static final String TAG_SCHEDULING_MODE = "sm";
    private final Consumer<SchedulingMode> listener;
    private SchedulingModeType type;
    private SchedulingMode schedulingMode;

    public SchedulingModeContainer(Consumer<SchedulingMode> listener) {
        this.listener = listener;
        this.type = SchedulingModeType.DEFAULT;
        this.schedulingMode = this.type.createSchedulingMode(null, tasks -> Collections.shuffle(tasks, new Random()), this::notifyListener);
        this.notifyListener();
    }

    public SchedulingModeType getType() {
        return this.type;
    }

    public void setType(SchedulingModeType type) {
        this.setType(null, type);
    }

    private void setType(@Nullable CompoundTag tag, SchedulingModeType newType) {
        this.type = newType;
        this.schedulingMode = newType.createSchedulingMode(tag, tasks -> Collections.shuffle(tasks, new Random()), this::notifyListener);
        this.notifyListener();
    }

    private void notifyListener() {
        this.listener.accept(this.schedulingMode);
    }

    public void loadFromTag(CompoundTag tag) {
        if (tag.contains(TAG_SCHEDULING_MODE)) {
            this.setType(tag, SchedulingModeType.getById(tag.getInt(TAG_SCHEDULING_MODE)));
        }
    }

    public void writeToTag(CompoundTag tag) {
        tag.putInt(TAG_SCHEDULING_MODE, this.type.getId());
        this.type.writeToTag(tag, this.schedulingMode);
    }

    public void execute(List<? extends SchedulingMode.ScheduledTask> tasks) {
        this.schedulingMode.execute(tasks);
    }
}

