/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.storage.portablegrid.AbstractPortableGridBlockEntity;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockEntityTicker;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridType;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PortableGridBlock
extends AbstractDirectionalBlock<BiDirection>
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final VoxelShape SHAPE_HORIZONTAL = PortableGridBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.2, (double)16.0);
    private static final VoxelShape SHAPE_VERTICAL_SOUTH = PortableGridBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.2);
    private static final VoxelShape SHAPE_VERTICAL_NORTH = PortableGridBlock.box((double)0.0, (double)0.0, (double)2.8000000000000007, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_VERTICAL_EAST = PortableGridBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.2, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_VERTICAL_WEST = PortableGridBlock.box((double)2.8000000000000007, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final PortableGridBlockEntityTicker ticker = new PortableGridBlockEntityTicker(() -> type == PortableGridType.NORMAL ? BlockEntities.INSTANCE.getPortableGrid() : BlockEntities.INSTANCE.getCreativePortableGrid());
    private final BlockEntityProvider<AbstractPortableGridBlockEntity> blockEntityProvider;

    public PortableGridBlock(PortableGridType type, BlockEntityProvider<AbstractPortableGridBlockEntity> blockEntityProvider) {
        super(BlockConstants.PROPERTIES);
        this.blockEntityProvider = blockEntityProvider;
    }

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    @Override
    protected DirectionType<BiDirection> getDirectionType() {
        return BiDirectionType.INSTANCE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BiDirection direction = (BiDirection)((Object)this.getDirection(state));
        if (direction == null) {
            return SHAPE_HORIZONTAL;
        }
        return switch (direction) {
            case BiDirection.UP_SOUTH, BiDirection.DOWN_SOUTH -> SHAPE_VERTICAL_SOUTH;
            case BiDirection.UP_NORTH, BiDirection.DOWN_NORTH -> SHAPE_VERTICAL_NORTH;
            case BiDirection.UP_EAST, BiDirection.DOWN_EAST -> SHAPE_VERTICAL_EAST;
            case BiDirection.UP_WEST, BiDirection.DOWN_WEST -> SHAPE_VERTICAL_WEST;
            default -> SHAPE_HORIZONTAL;
        };
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.blockEntityProvider.create(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return this.ticker.get(level, type);
    }
}

