/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.configurationcard.ConfigurationCardTarget;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.support.energy.TransferableBlockEntityEnergy;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.PortableGridData;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.DiskStateChangeListener;
import com.refinedmods.refinedstorage.common.storage.portablegrid.InWorldPortableGrid;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGrid;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlock;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockContainerMenu;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridType;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.RedstoneModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.energy.BlockEntityEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.CreativeEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPortableGridBlockEntity
extends BlockEntity
implements ExtendedMenuProvider<PortableGridData>,
ConfigurationCardTarget,
TransferableBlockEntityEnergy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPortableGridBlockEntity.class);
    private static final String TAG_DISK_INVENTORY = "inv";
    private static final String TAG_DISKS = "disks";
    private static final String TAG_REDSTONE_MODE = "rm";
    private static final String TAG_CUSTOM_NAME = "CustomName";
    @Nullable
    protected Disk disk;
    @Nullable
    private Component name;
    private final DiskInventory diskInventory;
    private final DiskStateChangeListener diskStateListener = new DiskStateChangeListener(this);
    private final EnergyStorage energyStorage;
    private final RateLimiter activenessChangeRateLimiter = RateLimiter.create((double)1.0);
    private final PortableGrid grid;
    private final PortableGridType type;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    protected AbstractPortableGridBlockEntity(PortableGridType type, BlockPos pos, BlockState state) {
        super(AbstractPortableGridBlockEntity.getBlockEntityType(type), pos, state);
        this.diskInventory = new DiskInventory((inventory, slot) -> this.onDiskChanged(), 1);
        this.energyStorage = AbstractPortableGridBlockEntity.createEnergyStorage(type, this);
        this.grid = new InWorldPortableGrid(this.energyStorage, this.diskInventory, this.diskStateListener, this);
        this.type = type;
    }

    static void readDiskInventory(CompoundTag tag, DiskInventory diskInventory, HolderLookup.Provider provider) {
        if (tag.contains(TAG_DISK_INVENTORY)) {
            ContainerUtil.read(tag.getCompound(TAG_DISK_INVENTORY), (Container)diskInventory, provider);
        }
    }

    static void writeDiskInventory(CompoundTag tag, DiskInventory diskInventory, HolderLookup.Provider provider) {
        tag.put(TAG_DISK_INVENTORY, (Tag)ContainerUtil.write((Container)diskInventory, provider));
    }

    static ItemStack getDisk(CustomData customData, HolderLookup.Provider provider) {
        CompoundTag tag = customData.copyTag();
        if (!tag.contains(TAG_DISK_INVENTORY)) {
            return ItemStack.EMPTY;
        }
        return ContainerUtil.getItemInSlot(tag.getCompound(TAG_DISK_INVENTORY), 0, provider);
    }

    private static EnergyStorage createEnergyStorage(PortableGridType type, BlockEntity blockEntity) {
        if (type == PortableGridType.CREATIVE) {
            return CreativeEnergyStorage.INSTANCE;
        }
        return new BlockEntityEnergyStorage(new EnergyStorageImpl(Platform.INSTANCE.getConfig().getPortableGrid().getEnergyCapacity()), blockEntity);
    }

    Grid getGrid() {
        return this.grid;
    }

    void update(BlockState state) {
        boolean activenessNeedsUpdate;
        this.diskStateListener.updateIfNecessary();
        boolean newActive = this.grid.isGridActive();
        boolean bl = activenessNeedsUpdate = (Boolean)state.getValue((Property)PortableGridBlock.ACTIVE) != newActive;
        if (activenessNeedsUpdate && this.activenessChangeRateLimiter.tryAcquire()) {
            this.updateActivenessBlockState(state, newActive);
            this.grid.activeChanged(newActive);
        }
    }

    private void updateActivenessBlockState(BlockState state, boolean active) {
        if (this.level != null) {
            LOGGER.debug("Sending block update at {} due to activeness change: {} -> {}", new Object[]{this.getBlockPos(), state.getValue((Property)PortableGridBlock.ACTIVE), active});
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)PortableGridBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    private void onDiskChanged() {
        boolean isJustPlacedIntoLevelOrLoading;
        boolean bl = isJustPlacedIntoLevelOrLoading = this.level == null || this.level.isClientSide();
        if (isJustPlacedIntoLevelOrLoading) {
            return;
        }
        this.grid.updateStorage();
        PlatformUtil.sendBlockUpdateToClient(this.level, this.worldPosition);
        this.setChanged();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.initialize(level);
        }
    }

    private void initialize(Level level) {
        this.diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository(level));
        this.grid.updateStorage();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.fromClientTag(tag);
        AbstractPortableGridBlockEntity.readDiskInventory(tag, this.diskInventory, provider);
        ItemBlockEnergyStorage.readFromTag(this.energyStorage, tag);
        this.readConfiguration(tag, provider);
        super.loadAdditional(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_REDSTONE_MODE)) {
            this.redstoneMode = RedstoneModeSettings.getRedstoneMode(tag.getInt(TAG_REDSTONE_MODE));
        }
        if (tag.contains(TAG_CUSTOM_NAME, 8)) {
            this.name = AbstractPortableGridBlockEntity.parseCustomNameSafe((String)tag.getString(TAG_CUSTOM_NAME), (HolderLookup.Provider)provider);
        }
    }

    private void fromClientTag(CompoundTag tag) {
        if (!tag.contains(TAG_DISKS)) {
            return;
        }
        this.disk = this.diskInventory.fromSyncTag(tag.getList(TAG_DISKS, 10))[0];
        this.onClientDriveStateUpdated();
    }

    protected void onClientDriveStateUpdated() {
        Platform.INSTANCE.requestModelDataUpdateOnClient(this, true);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        AbstractPortableGridBlockEntity.writeDiskInventory(tag, this.diskInventory, provider);
        ItemBlockEnergyStorage.writeToTag(tag, this.energyStorage.getStored());
        this.writeConfiguration(tag, provider);
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt(TAG_REDSTONE_MODE, RedstoneModeSettings.getRedstoneMode(this.redstoneMode));
        if (this.name != null) {
            tag.putString(TAG_CUSTOM_NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.put(TAG_DISKS, (Tag)this.diskInventory.toSyncTag(idx -> this.grid.getStorageState()));
        return tag;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.setChanged();
    }

    public Component getDisplayName() {
        MutableComponent defaultName = this.type == PortableGridType.CREATIVE ? ContentNames.CREATIVE_PORTABLE_GRID : ContentNames.PORTABLE_GRID;
        return this.name == null ? defaultName : this.name;
    }

    @Nullable
    public AbstractGridContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new PortableGridBlockContainerMenu(syncId, inventory, this);
    }

    @Override
    public PortableGridData getMenuData() {
        return new PortableGridData(GridData.of(this.grid), this.energyStorage.getStored(), this.energyStorage.getCapacity(), Optional.empty());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, PortableGridData> getMenuCodec() {
        return PortableGridData.STREAM_CODEC;
    }

    DiskInventory getDiskInventory() {
        return this.diskInventory;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private static BlockEntityType<AbstractPortableGridBlockEntity> getBlockEntityType(PortableGridType type) {
        return type == PortableGridType.CREATIVE ? BlockEntities.INSTANCE.getCreativePortableGrid() : BlockEntities.INSTANCE.getPortableGrid();
    }
}

