/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockEntity;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.storage.StorageTooltipHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerItemHelperImpl
implements StorageContainerItemHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageContainerItemHelperImpl.class);

    @Override
    public Optional<SerializableStorage> resolveStorage(StorageRepository storageRepository, ItemStack stack) {
        return this.getId(stack).flatMap(storageRepository::get);
    }

    @Override
    public void loadStorageIfNecessary(ItemStack stack, Level level, Entity entity, Function<StorageRepository, SerializableStorage> factory) {
        if (!level.isClientSide() && !this.hasStorage(stack) && entity instanceof Player) {
            StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(level);
            this.setStorage(storageRepository, stack, factory.apply(storageRepository));
        }
    }

    @Override
    public void transferStorageIfNecessary(ItemStack stack, Level level, Entity entity, Function<StorageRepository, SerializableStorage> factory) {
        if (!level.isClientSide() && !this.hasStorage(stack) && this.hasStorageToBeTransferred(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            this.getIdToBeTransferred(stack).ifPresent(id -> this.doTransfer(level, factory, player, (UUID)id, stack));
        }
    }

    private void doTransfer(Level level, Function<StorageRepository, SerializableStorage> factory, Player player, UUID originalId, ItemStack stack) {
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        PlayerActor actor = new PlayerActor(player);
        storageRepository.get(originalId).ifPresent(originalStorage -> {
            SerializableStorage transferStorage = (SerializableStorage)factory.apply(storageRepository);
            originalStorage.getAll().forEach(original -> transferStorage.insert(original.resource(), original.amount(), Action.EXECUTE, actor));
            this.setStorage(storageRepository, stack, transferStorage);
            storageRepository.remove(originalId);
            this.markAsTransferred(stack);
        });
    }

    private void setStorage(StorageRepository storageRepository, ItemStack stack, SerializableStorage storage) {
        UUID id = UUID.randomUUID();
        this.setId(stack, id);
        storageRepository.set(id, storage);
    }

    private boolean hasStorage(ItemStack stack) {
        return stack.has(DataComponents.INSTANCE.getStorageReference());
    }

    private boolean hasStorageToBeTransferred(ItemStack stack) {
        return stack.has(DataComponents.INSTANCE.getStorageReferenceToBeTransferred());
    }

    @Override
    public Optional<StorageInfo> getInfo(StorageRepository storageRepository, ItemStack stack) {
        return this.getId(stack).map(storageRepository::getInfo);
    }

    @Override
    public InteractionResultHolder<ItemStack> tryDisassembly(Level level, Player player, ItemStack stack, ItemStack primaryByproduct, @Nullable ItemStack secondaryByproduct) {
        if (!(level instanceof ServerLevel) || !player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        Optional<UUID> storageId = this.getId(stack);
        if (storageId.isEmpty()) {
            return this.returnByproducts(level, player, primaryByproduct, secondaryByproduct);
        }
        return storageId.flatMap(id -> RefinedStorageApi.INSTANCE.getStorageRepository(level).removeIfEmpty((UUID)id)).map(disk -> this.returnByproducts(level, player, primaryByproduct, secondaryByproduct)).orElseGet(() -> InteractionResultHolder.fail((Object)stack));
    }

    private InteractionResultHolder<ItemStack> returnByproducts(Level level, Player player, ItemStack primaryByproduct, @Nullable ItemStack secondaryByproduct) {
        StorageContainerItemHelperImpl.tryReturnByproductToInventory(level, player, secondaryByproduct);
        return InteractionResultHolder.success((Object)primaryByproduct);
    }

    private static void tryReturnByproductToInventory(Level level, Player player, @Nullable ItemStack byproduct) {
        if (byproduct != null && !player.getInventory().add(byproduct.copy())) {
            level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), byproduct));
        }
    }

    @Override
    public void appendToTooltip(ItemStack stack, StorageRepository storageRepository, List<Component> tooltip, TooltipFlag context, LongFunction<String> amountFormatter, @Nullable Long capacity) {
        boolean transferring = this.hasStorageToBeTransferred(stack);
        this.getId(stack).or(() -> this.getIdToBeTransferred(stack)).ifPresent(id -> {
            StorageInfo info = storageRepository.getInfo((UUID)id);
            if (capacity != null) {
                StorageTooltipHelper.addAmountStoredWithCapacity(tooltip, info.stored(), transferring ? capacity.longValue() : info.capacity(), amountFormatter);
            } else {
                StorageTooltipHelper.addAmountStoredWithoutCapacity(tooltip, info.stored(), amountFormatter);
            }
            if (context.isAdvanced()) {
                MutableComponent idComponent = Component.literal((String)id.toString()).withStyle(ChatFormatting.GRAY);
                tooltip.add((Component)idComponent);
            }
        });
    }

    @Override
    public void transferToBlockEntity(ItemStack stack, StorageBlockEntity blockEntity) {
        this.getId(stack).ifPresent(id -> {
            blockEntity.setStorageId((UUID)id);
            LOGGER.debug("Transferred storage {} to block entity {}", id, (Object)blockEntity);
        });
    }

    @Override
    public void transferFromBlockEntity(ItemStack stack, StorageBlockEntity blockEntity) {
        UUID storageId = blockEntity.getStorageId();
        if (storageId != null) {
            LOGGER.debug("Transferred storage {} from block entity {} to stack", (Object)storageId, (Object)blockEntity);
            this.setId(stack, storageId);
        } else {
            LOGGER.warn("Could not transfer storage {} to stack, there is no storage ID!", (Object)blockEntity);
        }
    }

    @Override
    public void markAsToTransfer(ItemStack from, ItemStack to) {
        this.getId(from).ifPresent(id -> to.set(DataComponents.INSTANCE.getStorageReferenceToBeTransferred(), id));
    }

    private Optional<UUID> getId(ItemStack stack) {
        return Optional.ofNullable((UUID)stack.get(DataComponents.INSTANCE.getStorageReference()));
    }

    @Override
    public boolean clear(ItemStack stack) {
        if (this.getId(stack).isEmpty()) {
            return false;
        }
        stack.remove(DataComponents.INSTANCE.getStorageReference());
        return true;
    }

    private Optional<UUID> getIdToBeTransferred(ItemStack stack) {
        return Optional.ofNullable((UUID)stack.get(DataComponents.INSTANCE.getStorageReferenceToBeTransferred()));
    }

    private void markAsTransferred(ItemStack stack) {
        stack.remove(DataComponents.INSTANCE.getStorageReferenceToBeTransferred());
    }

    private void setId(ItemStack stack, UUID id) {
        stack.set(DataComponents.INSTANCE.getStorageReference(), (Object)id);
    }
}

