/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public enum ItemStorageVariant implements StringRepresentable,
StorageVariant
{
    ONE_K("1k", 1024L),
    FOUR_K("4k", 4096L),
    SIXTEEN_K("16k", 16384L),
    SIXTY_FOUR_K("64k", 65536L),
    CREATIVE("creative", null);

    private final String name;
    @Nullable
    private final Long capacity;

    private ItemStorageVariant(String name, Long capacity) {
        this.name = name;
        this.capacity = capacity;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Long getCapacity() {
        return this.capacity;
    }

    @Override
    @Nullable
    public Item getStoragePart() {
        if (this == CREATIVE) {
            return null;
        }
        return Items.INSTANCE.getItemStoragePart(this);
    }

    public String getSerializedName() {
        return this.name;
    }
}

