/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.importer;

import com.refinedmods.refinedstorage.api.network.impl.node.importer.CompositeImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.ImporterNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.importer.ImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.importer.ImporterContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImporterBlockEntity
extends AbstractCableLikeBlockEntity<ImporterNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractImporterBlockEntity.class);
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_UPGRADES = "upgr";
    private final FilterWithFuzzyMode filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractImporterBlockEntity)this).setChanged(), this::setFilters);
    private final UpgradeContainer upgradeContainer;

    protected AbstractImporterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getImporter(), pos, state, new ImporterNetworkNode(Platform.INSTANCE.getConfig().getImporter().getEnergyUsage()));
        ((ImporterNetworkNode)this.mainNetworkNode).setNormalizer(this.filter.createNormalizer());
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.IMPORTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getImporter().getEnergyUsage();
            ((ImporterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
            this.setChanged();
            Level patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                this.initialize(serverLevel);
            }
        });
        this.ticker = this.upgradeContainer.getTicker();
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ImporterTransferStrategy strategy = this.createStrategy(level, direction);
        LOGGER.debug("Initialized importer at {} with strategy {}", (Object)this.worldPosition, (Object)strategy);
        ((ImporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    private ImporterTransferStrategy createStrategy(ServerLevel serverLevel, Direction direction) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        List<ImporterTransferStrategyFactory> factories = RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().getAll();
        return new CompositeImporterTransferStrategy(factories.stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, this.upgradeContainer)).toList());
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read(tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(((ImporterNetworkNode)this.mainNetworkNode).getFilterMode()));
        this.filter.save(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_FILTER_MODE)) {
            ((ImporterNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode(tag.getInt(TAG_FILTER_MODE)));
        }
        this.filter.load(tag, provider);
    }

    void setFilters(Set<ResourceKey> filters) {
        ((ImporterNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    FilterMode getFilterMode() {
        return ((ImporterNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((ImporterNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.setChanged();
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.IMPORTER);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new ImporterContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, p -> Container.stillValidBlockEntity((BlockEntity)this, (Player)p));
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

