/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.query;

import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryFilter;
import com.refinedmods.refinedstorage.common.api.grid.GridResourceAttributeKeys;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.refinedmods.refinedstorage.common.grid.query.GridQueryParserException;
import com.refinedmods.refinedstorage.query.lexer.Lexer;
import com.refinedmods.refinedstorage.query.lexer.LexerException;
import com.refinedmods.refinedstorage.query.lexer.LexerTokenMappings;
import com.refinedmods.refinedstorage.query.lexer.Source;
import com.refinedmods.refinedstorage.query.lexer.Token;
import com.refinedmods.refinedstorage.query.lexer.TokenType;
import com.refinedmods.refinedstorage.query.parser.Parser;
import com.refinedmods.refinedstorage.query.parser.ParserException;
import com.refinedmods.refinedstorage.query.parser.ParserOperatorMappings;
import com.refinedmods.refinedstorage.query.parser.node.BinOpNode;
import com.refinedmods.refinedstorage.query.parser.node.LiteralNode;
import com.refinedmods.refinedstorage.query.parser.node.Node;
import com.refinedmods.refinedstorage.query.parser.node.ParenNode;
import com.refinedmods.refinedstorage.query.parser.node.UnaryOpNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

public class GridQueryParser {
    private static final Map<String, Set<GridResourceAttributeKey>> ATTRIBUTE_MAPPING = Map.of("@", Set.of(GridResourceAttributeKeys.MOD_ID, GridResourceAttributeKeys.MOD_NAME), "#", Set.of(GridResourceAttributeKeys.TAGS), "$", Set.of(GridResourceAttributeKeys.TOOLTIP));
    private final LexerTokenMappings tokenMappings;
    private final ParserOperatorMappings operatorMappings;

    public GridQueryParser(LexerTokenMappings tokenMappings, ParserOperatorMappings operatorMappings) {
        this.tokenMappings = tokenMappings;
        this.operatorMappings = operatorMappings;
    }

    public ResourceRepositoryFilter<GridResource> parse(String query) throws GridQueryParserException {
        if (query.trim().isEmpty()) {
            return (repository, resource) -> true;
        }
        List<Token> tokens = this.getTokens(query);
        List<Node> nodes = this.getNodes(tokens);
        return this.implicitAnd(nodes);
    }

    private List<Token> getTokens(String query) throws GridQueryParserException {
        try {
            Lexer lexer = new Lexer(new Source("Grid query input", query), this.tokenMappings);
            lexer.scan();
            return lexer.getTokens();
        }
        catch (LexerException e) {
            throw new GridQueryParserException(e.getMessage(), e);
        }
    }

    private List<Node> getNodes(List<Token> tokens) throws GridQueryParserException {
        try {
            Parser parser = new Parser(tokens, this.operatorMappings);
            parser.parse();
            return parser.getNodes();
        }
        catch (ParserException e) {
            throw new GridQueryParserException(e.getMessage(), e);
        }
    }

    private ResourceRepositoryFilter<GridResource> implicitAnd(List<Node> nodes) throws GridQueryParserException {
        ArrayList<ResourceRepositoryFilter<GridResource>> conditions = new ArrayList<ResourceRepositoryFilter<GridResource>>();
        for (Node node : nodes) {
            conditions.add(this.parseNode(node));
        }
        return GridQueryParser.and(conditions);
    }

    private ResourceRepositoryFilter<GridResource> parseNode(Node node) throws GridQueryParserException {
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LiteralNode.class, UnaryOpNode.class, BinOpNode.class, ParenNode.class}, (Object)node3, n)) {
            case 0 -> {
                LiteralNode literalNode = (LiteralNode)node3;
                yield GridQueryParser.parseLiteral(literalNode);
            }
            case 1 -> {
                UnaryOpNode unaryOpNode = (UnaryOpNode)node3;
                yield this.parseUnaryOp(unaryOpNode);
            }
            case 2 -> {
                BinOpNode binOpNode = (BinOpNode)node3;
                yield this.parseBinOp(binOpNode);
            }
            case 3 -> {
                ParenNode parenNode = (ParenNode)node3;
                yield this.implicitAnd(parenNode.nodes());
            }
            default -> throw new GridQueryParserException("Unsupported node", null);
        };
    }

    private ResourceRepositoryFilter<GridResource> parseBinOp(BinOpNode node) throws GridQueryParserException {
        String operator = node.binOp().content();
        if ("&&".equals(operator)) {
            return this.parseAndBinOpNode(node);
        }
        if ("||".equals(operator)) {
            return this.parseOrBinOpNode(node);
        }
        throw new GridQueryParserException("Unsupported operator: " + operator, null);
    }

    private ResourceRepositoryFilter<GridResource> parseAndBinOpNode(BinOpNode node) throws GridQueryParserException {
        return GridQueryParser.and(Arrays.asList(this.parseNode(node.left()), this.parseNode(node.right())));
    }

    private ResourceRepositoryFilter<GridResource> parseOrBinOpNode(BinOpNode node) throws GridQueryParserException {
        return GridQueryParser.or(Arrays.asList(this.parseNode(node.left()), this.parseNode(node.right())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourceRepositoryFilter<GridResource> parseUnaryOp(UnaryOpNode node) throws GridQueryParserException {
        String operator = node.operator().content();
        Node content = node.node();
        if ("!".equals(operator)) {
            return GridQueryParser.not(this.parseNode(content));
        }
        if (ATTRIBUTE_MAPPING.containsKey(operator)) {
            Set<GridResourceAttributeKey> keys = ATTRIBUTE_MAPPING.get(operator);
            if (!(content instanceof LiteralNode)) throw new GridQueryParserException("Expected a literal", null);
            LiteralNode literalNode = (LiteralNode)content;
            try {
                Token token;
                Token token2 = token = literalNode.token();
                return GridQueryParser.attributeMatch(keys, token2.content());
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (">".equals(operator)) {
            return GridQueryParser.count(content, (actualCount, wantedCount) -> actualCount > wantedCount);
        }
        if (">=".equals(operator)) {
            return GridQueryParser.count(content, (actualCount, wantedCount) -> actualCount >= wantedCount);
        }
        if ("<".equals(operator)) {
            return GridQueryParser.count(content, (actualCount, wantedCount) -> actualCount < wantedCount);
        }
        if ("<=".equals(operator)) {
            return GridQueryParser.count(content, (actualCount, wantedCount) -> actualCount <= wantedCount);
        }
        if (!"=".equals(operator)) throw new GridQueryParserException("Unsupported unary operator", null);
        return GridQueryParser.count(content, Long::equals);
    }

    private static ResourceRepositoryFilter<GridResource> count(Node node, BiPredicate<Long, Long> predicate) throws GridQueryParserException {
        if (!(node instanceof LiteralNode)) {
            throw new GridQueryParserException("Count filtering expects a literal", null);
        }
        if (((LiteralNode)node).token().type() != TokenType.INTEGER_NUMBER) {
            throw new GridQueryParserException("Count filtering expects an integer number", null);
        }
        long wantedCount = Long.parseLong(((LiteralNode)node).token().content());
        return (repository, resource) -> predicate.test(resource.getAmount((ResourceRepository<GridResource>)repository), wantedCount);
    }

    private static ResourceRepositoryFilter<GridResource> attributeMatch(Set<GridResourceAttributeKey> keys, String query) {
        return (repository, resource) -> keys.stream().map(resource::getAttribute).flatMap(Collection::stream).anyMatch(value -> GridQueryParser.normalize(value).contains(GridQueryParser.normalize(query)));
    }

    private static String normalize(String value) {
        return value.trim().toLowerCase(Locale.ROOT);
    }

    private static ResourceRepositoryFilter<GridResource> parseLiteral(LiteralNode node) {
        return (repository, resource) -> GridQueryParser.normalize(resource.getName()).contains(GridQueryParser.normalize(node.token().content()));
    }

    private static ResourceRepositoryFilter<GridResource> and(List<ResourceRepositoryFilter<GridResource>> chain) {
        return (repository, resource) -> {
            for (ResourceRepositoryFilter predicate : chain) {
                if (predicate.test(repository, resource)) continue;
                return false;
            }
            return true;
        };
    }

    private static ResourceRepositoryFilter<GridResource> or(List<ResourceRepositoryFilter<GridResource>> chain) {
        return (repository, resource) -> {
            for (ResourceRepositoryFilter predicate : chain) {
                if (!predicate.test(repository, resource)) continue;
                return true;
            }
            return false;
        };
    }

    private static ResourceRepositoryFilter<GridResource> not(ResourceRepositoryFilter<GridResource> predicate) {
        return (repository, resource) -> !predicate.test((GridResource)repository, resource);
    }
}

