/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.detector;

import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorMode;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.detector.DetectorBlockEntity;
import com.refinedmods.refinedstorage.common.detector.DetectorPropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractSingleAmountContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.SingleAmountData;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DetectorContainerMenu
extends AbstractSingleAmountContainerMenu {
    private static final Component FILTER_HELP = IdentifierUtil.createTranslation("gui", "detector.filter_help");
    private final Predicate<Player> stillValid;
    @Nullable
    private DetectorBlockEntity detector;

    public DetectorContainerMenu(int syncId, Inventory playerInventory, SingleAmountData singleAmountData) {
        super(Menus.INSTANCE.getDetector(), syncId, playerInventory, singleAmountData, FILTER_HELP);
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
        this.registerProperty(new ClientProperty<DetectorMode>(DetectorPropertyTypes.MODE, DetectorMode.EQUAL));
        this.stillValid = p -> true;
    }

    DetectorContainerMenu(int syncId, Player player, DetectorBlockEntity detector, ResourceContainer resourceContainer) {
        super(Menus.INSTANCE.getDetector(), syncId, player, resourceContainer, FILTER_HELP, null);
        this.detector = detector;
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, detector::isFuzzyMode, detector::setFuzzyMode));
        this.registerProperty(new ServerProperty<DetectorMode>(DetectorPropertyTypes.MODE, detector::getMode, detector::setMode));
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)detector, (Player)p);
    }

    @Override
    public void changeAmountOnServer(double newAmount) {
        if (this.detector == null) {
            return;
        }
        this.detector.setAmount(newAmount);
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

