/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlaceFluidConstructorStrategy
implements ConstructorStrategy {
    protected final ServerLevel level;
    protected final BlockPos pos;
    protected final Direction direction;

    public PlaceFluidConstructorStrategy(ServerLevel level, BlockPos pos, Direction direction) {
        this.level = level;
        this.pos = pos;
        this.direction = direction;
    }

    @Override
    public ConstructorStrategy.Result apply(ResourceKey resource, Actor actor, Player player, Network network) {
        if (!this.level.isLoaded(this.pos)) {
            return ConstructorStrategy.Result.SKIPPED;
        }
        if (!(resource instanceof FluidResource)) {
            return ConstructorStrategy.Result.SKIPPED;
        }
        FluidResource fluidResource = (FluidResource)resource;
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        long bucketAmount = Platform.INSTANCE.getBucketAmount();
        long extractedAmount = rootStorage.extract(fluidResource, bucketAmount, Action.SIMULATE, actor);
        if (bucketAmount != extractedAmount) {
            return ConstructorStrategy.Result.RESOURCE_MISSING;
        }
        boolean success = Platform.INSTANCE.placeFluid((Level)this.level, this.pos, this.direction, player, fluidResource);
        if (success) {
            rootStorage.extract(fluidResource, bucketAmount, Action.EXECUTE, actor);
        }
        return success ? ConstructorStrategy.Result.SUCCESS : ConstructorStrategy.Result.SKIPPED;
    }
}

