/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalCableBlock;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.DirectionalCableBlockShapes;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractConstructorDestructorBlock<T extends Block, B extends BlockEntity, I extends BlockItem>
extends AbstractDirectionalCableBlock
implements ColorableBlock<T, I>,
EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final ConcurrentHashMap<AbstractDirectionalCableBlock.DirectionalCacheShapeCacheKey, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap();
    private final AbstractBlockEntityTicker<B> ticker;
    private final DyeColor color;
    private final MutableComponent name;

    protected AbstractConstructorDestructorBlock(DyeColor color, MutableComponent name, AbstractBlockEntityTicker<B> ticker) {
        super(SHAPE_CACHE);
        this.color = color;
        this.name = name;
        this.ticker = ticker;
    }

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    @Override
    protected VoxelShape getExtensionShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> DirectionalCableBlockShapes.CONSTRUCTOR_DESTRUCTOR_NORTH;
            case Direction.EAST -> DirectionalCableBlockShapes.CONSTRUCTOR_DESTRUCTOR_EAST;
            case Direction.SOUTH -> DirectionalCableBlockShapes.CONSTRUCTOR_DESTRUCTOR_SOUTH;
            case Direction.WEST -> DirectionalCableBlockShapes.CONSTRUCTOR_DESTRUCTOR_WEST;
            case Direction.UP -> DirectionalCableBlockShapes.CONSTRUCTOR_DESTRUCTOR_UP;
            case Direction.DOWN -> DirectionalCableBlockShapes.CONSTRUCTOR_DESTRUCTOR_DOWN;
        };
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public MutableComponent getName() {
        return this.name;
    }

    @Nullable
    public <E extends BlockEntity> BlockEntityTicker<E> getTicker(Level level, BlockState blockState, BlockEntityType<E> type) {
        return this.ticker.get(level, type);
    }
}

