/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

class AutocraftingMonitorItemTooltip
implements ClientTooltipComponent {
    private static final int SPACING = 2;
    private static final MutableComponent MACHINE_DOES_NOT_ACCEPT_RESOURCE = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.machine_does_not_accept_resource").withStyle(ChatFormatting.RED);
    private static final MutableComponent NO_MACHINE_FOUND = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.no_machine_found").withStyle(ChatFormatting.RED);
    private static final MutableComponent AUTOCRAFTER_IS_LOCKED = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.autocrafter_is_locked").withStyle(ChatFormatting.RED);
    private final TaskStatus.Item item;
    private final ResourceRendering rendering;

    AutocraftingMonitorItemTooltip(TaskStatus.Item item) {
        this.item = item;
        this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(item.resource().getClass());
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        ExternalPatternSinkKey externalPatternSinkKey;
        int yy = y;
        graphics.drawString(font, this.rendering.getDisplayName(this.item.resource()), x, yy, 0xFFFFFF);
        yy += 11;
        if (this.item.type() != TaskStatus.ItemType.NORMAL) {
            graphics.drawString(font, this.getErrorTooltip(this.item.type()), x, yy, 0xAAAAAA);
            yy += 11;
        }
        if ((externalPatternSinkKey = this.item.sinkKey()) instanceof InWorldExternalPatternSinkKey) {
            String name;
            String string;
            InWorldExternalPatternSinkKey inWorldExternalPatternSinkKey = (InWorldExternalPatternSinkKey)externalPatternSinkKey;
            try {
                name = string = inWorldExternalPatternSinkKey.name();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            String stack = string = inWorldExternalPatternSinkKey.stack();
            graphics.renderItem((ItemStack)stack, x, yy);
            graphics.drawString(font, name, x + 18 + 2, yy + 4, 0xAAAAAA);
        }
    }

    public int getHeight() {
        return 11 + (this.item.type() != TaskStatus.ItemType.NORMAL ? 11 : 0) + (this.item.sinkKey() != null ? 18 : 0);
    }

    public int getWidth(Font font) {
        int n;
        int resourceWidth = font.width((FormattedText)this.rendering.getDisplayName(this.item.resource()));
        int errorWidth = this.item.type() != TaskStatus.ItemType.NORMAL ? font.width((FormattedText)this.getErrorTooltip(this.item.type())) : 0;
        ExternalPatternSinkKey externalPatternSinkKey = this.item.sinkKey();
        if (externalPatternSinkKey instanceof InWorldExternalPatternSinkKey) {
            InWorldExternalPatternSinkKey sinkKey = (InWorldExternalPatternSinkKey)externalPatternSinkKey;
            n = 20 + font.width(sinkKey.name());
        } else {
            n = 0;
        }
        int sinkWidth = n;
        return Math.max(resourceWidth, Math.max(errorWidth, sinkWidth));
    }

    private Component getErrorTooltip(TaskStatus.ItemType type) {
        return switch (type) {
            case TaskStatus.ItemType.REJECTED -> MACHINE_DOES_NOT_ACCEPT_RESOURCE;
            case TaskStatus.ItemType.NONE_FOUND -> NO_MACHINE_FOUND;
            case TaskStatus.ItemType.LOCKED -> AUTOCRAFTER_IS_LOCKED;
            default -> Component.empty();
        };
    }
}

