/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocrafter;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterPropertyTypes;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockMode;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AutocrafterContainerMenu
extends AbstractBaseContainerMenu {
    private static final int PATTERN_SLOT_X = 8;
    private static final int PATTERN_SLOT_Y = 20;
    private final Player player;
    private final boolean partOfChain;
    private final boolean headOfChain;
    private boolean locked;
    private final RateLimiter nameRateLimiter = RateLimiter.create((double)0.5);
    @Nullable
    private AutocrafterBlockEntity autocrafter;
    @Nullable
    private Listener listener;
    private Component name;

    public AutocrafterContainerMenu(int syncId, Inventory playerInventory, AutocrafterData data) {
        super(Menus.INSTANCE.getAutocrafter(), syncId);
        this.player = playerInventory.player;
        this.registerProperty(new ClientProperty<LockMode>(AutocrafterPropertyTypes.LOCK_MODE, LockMode.NEVER));
        this.registerProperty(new ClientProperty<Integer>(AutocrafterPropertyTypes.PRIORITY, 0));
        this.registerProperty(new ClientProperty<Boolean>(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, true));
        this.addSlots(new PatternInventory(9, () -> ((Player)playerInventory.player).level()), new UpgradeContainer(UpgradeDestinations.AUTOCRAFTER));
        this.name = Component.empty();
        this.partOfChain = data.partOfChain();
        this.headOfChain = data.headOfChain();
        this.locked = data.locked();
    }

    public AutocrafterContainerMenu(int syncId, Inventory playerInventory, AutocrafterBlockEntity autocrafter) {
        super(Menus.INSTANCE.getAutocrafter(), syncId);
        this.autocrafter = autocrafter;
        this.player = playerInventory.player;
        this.name = autocrafter.getDisplayName();
        this.partOfChain = false;
        this.headOfChain = false;
        this.locked = autocrafter.isLocked();
        this.registerProperty(new ServerProperty<LockMode>(AutocrafterPropertyTypes.LOCK_MODE, autocrafter::getLockMode, autocrafter::setLockMode));
        this.registerProperty(new ServerProperty<Integer>(AutocrafterPropertyTypes.PRIORITY, autocrafter::getPriority, autocrafter::setPriority));
        this.registerProperty(new ServerProperty<Boolean>(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, autocrafter::isVisibleToTheAutocrafterManager, autocrafter::setVisibleToTheAutocrafterManager));
        this.addSlots(autocrafter.getPatternContainer(), autocrafter.getUpgradeContainer());
    }

    boolean canChangeName() {
        return !this.partOfChain;
    }

    boolean isPartOfChain() {
        return this.partOfChain;
    }

    boolean isHeadOfChain() {
        return this.headOfChain;
    }

    boolean isLocked() {
        return this.locked;
    }

    void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void broadcastChanges() {
        boolean newLocked;
        super.broadcastChanges();
        if (this.autocrafter == null) {
            return;
        }
        if (this.nameRateLimiter.tryAcquire()) {
            this.detectNameChange();
        }
        if (this.locked != (newLocked = this.autocrafter.isLocked())) {
            this.locked = newLocked;
            S2CPackets.sendAutocrafterLockedUpdate((ServerPlayer)this.player, this.locked);
        }
    }

    public boolean stillValid(Player p) {
        if (this.autocrafter == null) {
            return true;
        }
        return Container.stillValidBlockEntity((BlockEntity)this.autocrafter, (Player)p);
    }

    private void detectNameChange() {
        if (this.autocrafter == null) {
            return;
        }
        Component newName = this.autocrafter.getDisplayName();
        if (!newName.equals((Object)this.name)) {
            this.name = newName;
            S2CPackets.sendAutocrafterNameUpdate((ServerPlayer)this.player, newName);
        }
    }

    private void addSlots(FilteredContainer patternContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < patternContainer.getContainerSize(); ++i) {
            this.addSlot(this.createPatternSlot(patternContainer, i, this.player.level()));
        }
        for (i = 0; i < upgradeContainer.getContainerSize(); ++i) {
            this.addSlot(new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
        }
        this.addPlayerInventory(this.player.getInventory(), 8, 55);
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)upgradeContainer);
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)patternContainer);
    }

    private Slot createPatternSlot(FilteredContainer patternContainer, int i, Level level) {
        int x = 8 + 18 * i;
        return new PatternSlot((Container)patternContainer, i, x, 20, level);
    }

    public boolean containsPattern(ItemStack stack) {
        for (Slot slot : this.slots) {
            PatternSlot patternSlot;
            if (!(slot instanceof PatternSlot) || (patternSlot = (PatternSlot)slot).getItem() != stack) continue;
            return true;
        }
        return false;
    }

    public void changeName(String newName) {
        if (this.partOfChain) {
            return;
        }
        if (this.autocrafter != null) {
            this.autocrafter.setCustomName(newName);
            this.detectNameChange();
        } else {
            C2SPackets.sendAutocrafterNameChange(newName);
        }
    }

    public void nameChanged(Component newName) {
        if (this.listener != null) {
            this.listener.nameChanged(newName);
        }
    }

    public void lockedChanged(boolean newLocked) {
        this.locked = newLocked;
        if (this.listener != null) {
            this.listener.lockedChanged(newLocked);
        }
    }

    public static interface Listener {
        public void nameChanged(Component var1);

        public void lockedChanged(boolean var1);
    }
}

