/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingAutocraftingRequests {
    private static final Logger LOGGER = LoggerFactory.getLogger(PendingAutocraftingRequests.class);
    private final Set<CancellationToken> cancellationTokens = new HashSet<CancellationToken>();

    public <T> void add(CompletableFuture<T> future, CancellationToken cancellationToken) {
        this.cancellationTokens.add(cancellationToken);
        future.whenComplete((value, e) -> this.cancellationTokens.remove(cancellationToken));
    }

    public void cancelAll() {
        if (!this.cancellationTokens.isEmpty()) {
            LOGGER.info("Cancelling {} pending autocrafting requests", (Object)this.cancellationTokens.size());
        }
        this.cancellationTokens.forEach(CancellationToken::cancel);
        this.cancellationTokens.clear();
    }
}

