/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridInsertionHint;
import com.refinedmods.refinedstorage.common.api.grid.GridInsertionHints;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.grid.screen.hint.GridInsertionHintsImpl;
import com.refinedmods.refinedstorage.common.grid.screen.hint.ItemGridInsertionHint;
import com.refinedmods.refinedstorage.common.grid.screen.hint.SingleItemGridInsertionHint;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockContainerMenu;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockScreen;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResourceRendering;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public class RefinedStorageClientApiImpl
implements RefinedStorageClientApi {
    private final Map<Class<?>, ResourceRendering> resourceRenderingMap = new HashMap();
    private final Map<Item, ResourceLocation> diskModelsByItem = new HashMap<Item, ResourceLocation>();
    private final Set<ResourceLocation> diskModels = new HashSet<ResourceLocation>();
    private final GridInsertionHintsImpl gridInsertionHints = new GridInsertionHintsImpl(new ItemGridInsertionHint(), new SingleItemGridInsertionHint());

    @Override
    public AbstractContainerScreen<AbstractContainerMenu> createStorageBlockScreen(AbstractContainerMenu menu, Inventory inventory, Component title, Class<? extends ResourceKey> resourceClass) {
        return new StorageBlockScreen((StorageBlockContainerMenu)menu, inventory, title, this.getResourceRendering(resourceClass));
    }

    @Override
    public void openAutocraftingPreview(List<ResourceAmount> requests, @Nullable Screen parentScreen) {
        if (requests.isEmpty()) {
            return;
        }
        ClientPlatformUtil.openCraftingPreview(requests, parentScreen);
    }

    @Override
    public void addAlternativeGridInsertionHint(GridInsertionHint hint) {
        this.gridInsertionHints.addAlternativeHint(hint);
    }

    @Override
    public GridInsertionHints getGridInsertionHints() {
        return this.gridInsertionHints;
    }

    @Override
    public void registerDiskModel(Item item, ResourceLocation model) {
        this.diskModelsByItem.put(item, model);
        this.diskModels.add(model);
    }

    @Override
    public Set<ResourceLocation> getDiskModels() {
        return this.diskModels;
    }

    @Override
    public Map<Item, ResourceLocation> getDiskModelsByItem() {
        return Collections.unmodifiableMap(this.diskModelsByItem);
    }

    @Override
    public <T extends ResourceKey> void registerResourceRendering(Class<T> resourceClass, ResourceRendering rendering) {
        this.resourceRenderingMap.put(resourceClass, rendering);
    }

    @Override
    public <T extends ResourceKey> ResourceRendering getResourceRendering(Class<T> resourceClass) {
        if (resourceClass == ItemResource.class) {
            return ItemResourceRendering.INSTANCE;
        }
        return this.resourceRenderingMap.get(resourceClass);
    }
}

