/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public abstract class AbstractNetworkNode
implements NetworkNode {
    @Nullable
    protected Network network;
    private boolean active;

    @Override
    @Nullable
    public Network getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(@Nullable Network network) {
        this.network = network;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.onActiveChanged(active);
    }

    public boolean isActive() {
        return this.active;
    }

    public void doWork() {
        if (this.network == null || !this.active) {
            return;
        }
        this.network.getComponent(EnergyNetworkComponent.class).extract(this.getEnergyUsage());
    }

    protected void onActiveChanged(boolean newActive) {
    }

    public abstract long getEnergyUsage();
}

