/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import java.util.List;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.util.BeamData;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ItemBeamMessage(BlockPos pos, List<BeamData> beams) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ItemBeamMessage> TYPE = new CustomPacketPayload.Type(MiscUtil.RL("item_beam"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemBeamMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ItemBeamMessage::pos, (StreamCodec)BeamData.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemBeamMessage::beams, ItemBeamMessage::new);

    public static ItemBeamMessage create(BlockPos pos, List<BeamData> beams) {
        return new ItemBeamMessage(pos, List.copyOf(beams));
    }

    public static void handleData(ItemBeamMessage message, IPayloadContext context) {
        context.player().level().getBlockEntity(message.pos(), ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(te -> message.beams().forEach(te::addItemBeam));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

