/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledDropperModule;
import me.desht.modularrouters.logic.settings.RelativeDirection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CompiledFlingerModule
extends CompiledDropperModule {
    private final FlingerSettings settings;

    public CompiledFlingerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.settings = (FlingerSettings)stack.getOrDefault(ModDataComponents.FLINGER_SETTINGS, (Object)FlingerSettings.DEFAULT);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean fired = super.execute(router);
        if (fired && ((Boolean)ConfigHolder.common.module.flingerEffects.get()).booleanValue()) {
            Level level;
            ModuleTarget target = this.getTarget();
            int n = Math.round(this.getSpeed() * 5.0f);
            BlockPos pos = target.gPos.pos();
            if (router.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 2 && (level = router.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, n, 0.0, 0.0, 0.0, 0.0);
            }
            router.playSound(null, pos, ModSounds.THUD.get(), SoundSource.BLOCKS, 0.5f + this.getSpeed(), 1.0f);
        }
        return fired;
    }

    public float getYaw() {
        return this.settings.yaw;
    }

    public float getPitch() {
        return this.settings.pitch;
    }

    public float getSpeed() {
        return this.settings.speed;
    }

    @Override
    protected void setupItemVelocity(ModularRouterBlockEntity router, ItemEntity item) {
        Direction routerFacing = router.getAbsoluteFacing(RelativeDirection.FRONT);
        float basePitch = 0.0f;
        double yawRad = Math.toRadians((switch (this.getDirection()) {
            case RelativeDirection.UP -> {
                basePitch = 90.0f;
                yield this.yawFromFacing(routerFacing);
            }
            case RelativeDirection.DOWN -> {
                basePitch = -90.0f;
                yield this.yawFromFacing(routerFacing);
            }
            default -> this.yawFromFacing(this.getAbsoluteFacing());
        }) + this.getYaw());
        double pitchRad = Math.toRadians(basePitch + this.getPitch());
        double x = Math.cos(yawRad) * Math.cos(pitchRad);
        double y = Math.sin(pitchRad);
        double z = -(Math.sin(yawRad) * Math.cos(pitchRad));
        item.setDeltaMovement(new Vec3(x, y, z).scale((double)this.getSpeed()));
    }

    private float yawFromFacing(Direction absoluteFacing) {
        return switch (absoluteFacing) {
            case Direction.EAST -> 0.0f;
            case Direction.NORTH -> 90.0f;
            case Direction.WEST -> 180.0f;
            case Direction.SOUTH -> 270.0f;
            default -> 0.0f;
        };
    }

    public record FlingerSettings(float speed, float pitch, float yaw) {
        public static final FlingerSettings DEFAULT = new FlingerSettings(0.0f, 0.0f, 0.0f);
        public static final Codec<FlingerSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("speed").forGetter(FlingerSettings::speed), (App)Codec.FLOAT.fieldOf("pitch").forGetter(FlingerSettings::pitch), (App)Codec.FLOAT.optionalFieldOf("yaw", (Object)Float.valueOf(0.0f)).forGetter(FlingerSettings::yaw)).apply((Applicative)builder, FlingerSettings::new));
        public static StreamCodec<FriendlyByteBuf, FlingerSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, FlingerSettings::speed, (StreamCodec)ByteBufCodecs.FLOAT, FlingerSettings::pitch, (StreamCodec)ByteBufCodecs.FLOAT, FlingerSettings::yaw, FlingerSettings::new);
    }
}

