/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import java.util.List;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.gui.upgrade.SyncUpgradeScreen;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SyncUpgrade
extends UpgradeItem {
    public SyncUpgrade() {
        super(ModItems.defaultProps().component(ModDataComponents.SYNC_TUNING, (Object)1));
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        int val = SyncUpgrade.getTunedValue(itemstack);
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.sync.tuning", ClientUtil.colorText(val, ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    public void onCompiled(ItemStack stack, ModularRouterBlockEntity router) {
        router.setTunedSyncValue(SyncUpgrade.getTunedValue(stack));
    }

    public static int getTunedValue(ItemStack stack) {
        if (!(stack.getItem() instanceof SyncUpgrade)) {
            return 0;
        }
        return (Integer)stack.getOrDefault(ModDataComponents.SYNC_TUNING.get(), (Object)0);
    }

    public static void setTunedValue(ItemStack stack, int newValue) {
        if (stack.getItem() instanceof SyncUpgrade) {
            stack.set(ModDataComponents.SYNC_TUNING.get(), (Object)newValue);
        }
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(255, 255, 192);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide && !player.isSteppingCarefully()) {
            SyncUpgradeScreen.openSyncGui(stack, hand);
        } else if (player.isSteppingCarefully()) {
            if (!world.isClientSide) {
                SyncUpgrade.setTunedValue(stack, world.random.nextInt(((Integer)ConfigHolder.common.router.baseTickRate.get()).intValue()));
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.itemText.sync.tuning", (Object[])new Object[]{SyncUpgrade.getTunedValue(stack)}), true);
            } else {
                player.playSound(ModSounds.SUCCESS.get(), ((Double)ConfigHolder.common.sound.bleepVolume.get()).floatValue(), 1.5f);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

