/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.datagen;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.datagen.ModBlockStateProvider;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = ResourceLocation.parse((String)"item/generated");

    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "modularrouters", existingFileHelper);
    }

    @Nonnull
    public String getName() {
        return "Modular Routers Item Models";
    }

    protected void registerModels() {
        for (DeferredItem<? extends Item> registryObject : ModItems.REGISTRY_OBJECTS) {
            Item item;
            String name = registryObject.getId().getPath();
            Objects.requireNonNull((Item)registryObject.get());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleItem.class, UpgradeItem.class, AugmentItem.class, SmartFilterItem.class}, (Object)item, n)) {
                case 0: {
                    ModuleItem moduleItem = (ModuleItem)item;
                    if (moduleItem == ModItems.DISTRIBUTOR_MODULE.get() || moduleItem == ModItems.ENERGY_DISTRIBUTOR_MODULE.get()) {
                        ItemModelBuilder pullVariant = this.simpleItemVariant(registryObject, "_pull", ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/%s_pull", name));
                        this.simpleItem(registryObject, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/" + name, new Object[0])).override().predicate(this.modLoc("mode"), 0.5f).model((ModelFile)pullVariant);
                        break;
                    }
                    this.simpleItem(registryObject, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/" + name, new Object[0]));
                    break;
                }
                case 1: {
                    UpgradeItem upgradeItem = (UpgradeItem)item;
                    this.simpleItem(registryObject, ModBlockStateProvider.modid("item/upgrade/upgrade_layer0", new Object[0]), ModBlockStateProvider.modid("item/upgrade/upgrade_layer1", new Object[0]), ModBlockStateProvider.modid("item/upgrade/" + name, new Object[0]));
                    break;
                }
                case 2: {
                    AugmentItem augmentItem = (AugmentItem)item;
                    this.simpleItem(registryObject, ModBlockStateProvider.modid("item/augment/augment_layer0", new Object[0]), ModBlockStateProvider.modid("item/augment/" + name, new Object[0]));
                    break;
                }
                case 3: {
                    SmartFilterItem smartFilterItem = (SmartFilterItem)item;
                    this.simpleItem(registryObject, ModBlockStateProvider.modid("item/filter/" + name, new Object[0]));
                    break;
                }
            }
        }
        this.simpleItem(ModItems.BLANK_MODULE, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]));
        this.simpleItem(ModItems.BLANK_UPGRADE, ModBlockStateProvider.modid("item/upgrade/upgrade_layer0", new Object[0]), ModBlockStateProvider.modid("item/upgrade/upgrade_layer1", new Object[0]));
        this.simpleItem(ModItems.AUGMENT_CORE, ModBlockStateProvider.modid("item/augment/augment_layer0", new Object[0]));
        this.simpleItem(ModItems.OVERRIDE_CARD, ModBlockStateProvider.modid("item/override_card", new Object[0]));
        ((ItemModelBuilder)this.withExistingParent("manual", GENERATED)).texture("layer0", ModBlockStateProvider.modid("item/manual", new Object[0]));
    }

    private ItemModelBuilder simpleItem(DeferredItem<? extends Item> item, String ... textures) {
        return this.simpleItem(item.getId(), textures);
    }

    private ItemModelBuilder simpleItem(ResourceLocation itemKey, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(itemKey.getPath(), GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    private ItemModelBuilder simpleItemVariant(DeferredItem<? extends Item> item, String suffix, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(item.getId().getPath() + suffix, GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }
}

