/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.core;

import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.modularrouters.block.ModularRouterBlock;
import me.desht.modularrouters.block.TemplateFrameBlock;
import me.desht.modularrouters.core.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"modularrouters");
    public static final DeferredRegister.Items ITEMS = ModItems.ITEMS;
    private static final BlockBehaviour.Properties ROUTER_PROPS = BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.5f, 6.0f).sound(SoundType.METAL).noOcclusion();
    private static final BlockBehaviour.Properties TEMPLATE_FRAME_PROPS = BlockBehaviour.Properties.of().isValidSpawn((state, world, pos, entityType) -> false).noOcclusion();
    public static final DeferredBlock<ModularRouterBlock> MODULAR_ROUTER = ModBlocks.register("modular_router", () -> new ModularRouterBlock(ROUTER_PROPS));
    public static final Supplier<TemplateFrameBlock> TEMPLATE_FRAME = ModBlocks.registerNoItem("template_frame", () -> new TemplateFrameBlock(TEMPLATE_FRAME_PROPS));

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<? extends T> sup) {
        return ModBlocks.register(name, sup, ModBlocks::itemDefault);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<? extends T> sup, Function<Supplier<T>, Supplier<? extends Item>> itemCreator) {
        DeferredBlock<? extends T> ret = ModBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply((Supplier<DeferredBlock<? extends T>>)ret));
        return ret;
    }

    private static <T extends Block> DeferredBlock<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> itemDefault(Supplier<? extends Block> block) {
        return ModBlocks.item(block);
    }

    private static Supplier<BlockItem> item(Supplier<? extends Block> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties());
    }
}

