/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.handler.GhostItemHandler;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public abstract class BaseModuleHandler
extends GhostItemHandler {
    private final ItemStack holderStack;
    protected final ModularRouterBlockEntity router;
    private final DataComponentType<ItemContainerContents> componentType;
    private boolean autoSave = true;

    protected BaseModuleHandler(ItemStack holderStack, ModularRouterBlockEntity router, int size, DataComponentType<ItemContainerContents> componentType) {
        super(size);
        this.holderStack = holderStack;
        this.router = router;
        this.componentType = componentType;
        List stackList = ((ItemContainerContents)holderStack.getOrDefault(componentType, (Object)ItemContainerContents.EMPTY)).stream().limit(size).toList();
        for (int i = 0; i < size && i < stackList.size(); ++i) {
            this.setStackInSlot(i, (ItemStack)stackList.get(i));
        }
    }

    public void runBatchOperation(Runnable runnable) {
        this.autoSave = false;
        runnable.run();
        this.autoSave = true;
        this.save();
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    protected void onContentsChanged(int slot) {
        if (this.autoSave) {
            this.save();
            if (this.router != null) {
                this.router.recompileNeeded(ModularRouterBlockEntity.RecompileFlag.MODULES);
            }
        }
    }

    public static int getFilterItemCount(ItemStack holderStack, BiFunction<ItemStack, ModularRouterBlockEntity, BaseModuleHandler> factory) {
        BaseModuleHandler handler = factory.apply(holderStack, null);
        return (int)IntStream.range(0, handler.getSlots()).filter(i -> !handler.getStackInSlot(i).isEmpty()).count();
    }

    public void save() {
        this.holderStack.set(this.componentType, (Object)ItemContainerContents.fromItems((List)this.stacks));
    }

    public static class ModuleFilterHandler
    extends BaseModuleHandler {
        public ModuleFilterHandler(ItemStack holderStack, @Nullable ModularRouterBlockEntity router) {
            super(holderStack, router, 9, ModDataComponents.FILTER.get());
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return ((ModuleItem)this.getHolderStack().getItem()).isItemValidForFilter(stack);
        }
    }

    public static class BulkFilterHandler
    extends BaseModuleHandler {
        private final ItemStack moduleStack;
        private final int filterSlot;
        private final boolean shouldSave;

        public BulkFilterHandler(ItemStack holderStack, @Nullable ModularRouterBlockEntity router) {
            this(holderStack, router, ItemStack.EMPTY, 0, true);
        }

        public BulkFilterHandler(ItemStack holderStack, ModularRouterBlockEntity router, ItemStack moduleStack, int filterSlot, boolean shouldSave) {
            super(holderStack, router, 54, ModDataComponents.FILTER.get());
            this.moduleStack = moduleStack;
            this.filterSlot = filterSlot;
            this.shouldSave = shouldSave;
        }

        @Override
        public void save() {
            if (this.shouldSave) {
                super.save();
                if (!this.moduleStack.isEmpty()) {
                    ModuleFilterHandler h = new ModuleFilterHandler(this.moduleStack, this.router);
                    h.setStackInSlot(this.filterSlot, this.getHolderStack());
                    h.save();
                    ModularRouters.LOGGER.info("saved!");
                }
            }
        }
    }
}

