/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.textfield.FloatTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.logic.compiled.CompiledFlingerModule;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class FlingerModuleScreen
extends ModuleScreen {
    private FloatTextField speedField;
    private FloatTextField pitchField;
    private FloatTextField yawField;

    public FlingerModuleScreen(ModuleMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new TooltipButton(0, this.leftPos + 130, this.topPos + 15, "speed", 0.0f, 20.0f));
        this.addRenderableWidget((GuiEventListener)new TooltipButton(1, this.leftPos + 130, this.topPos + 33, "pitch", -90.0f, 90.0f));
        this.addRenderableWidget((GuiEventListener)new TooltipButton(2, this.leftPos + 130, this.topPos + 51, "yaw", -60.0f, 60.0f));
        CompiledFlingerModule cfm = new CompiledFlingerModule(null, this.moduleItemStack);
        this.speedField = new FloatTextField(this.font, this.leftPos + 152, this.topPos + 19, 35, 12, 0.0f, 20.0f);
        this.speedField.setPrecision(2);
        this.speedField.setValue(cfm.getSpeed());
        this.speedField.setResponder(str -> this.sendModuleSettingsDelayed(5));
        this.speedField.setIncr(0.1f, 0.5f, 10.0f);
        this.speedField.useGuiTextBackground();
        this.pitchField = new FloatTextField(this.font, this.leftPos + 152, this.topPos + 37, 35, 12, -90.0f, 90.0f);
        this.pitchField.setValue(cfm.getPitch());
        this.pitchField.setResponder(str -> this.sendModuleSettingsDelayed(5));
        this.pitchField.useGuiTextBackground();
        this.yawField = new FloatTextField(this.font, this.leftPos + 152, this.topPos + 55, 35, 12, -60.0f, 60.0f);
        this.yawField.setValue(cfm.getYaw());
        this.yawField.setResponder(str -> this.sendModuleSettingsDelayed(5));
        this.yawField.useGuiTextBackground();
        this.addRenderableWidget((GuiEventListener)this.speedField);
        this.addRenderableWidget((GuiEventListener)this.pitchField);
        this.addRenderableWidget((GuiEventListener)this.yawField);
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 128, this.topPos + 13, this.leftPos + 186, this.topPos + 32, "modularrouters.guiText.popup.flinger.speed");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 128, this.topPos + 31, this.leftPos + 186, this.topPos + 50, "modularrouters.guiText.popup.flinger.pitch");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 128, this.topPos + 49, this.leftPos + 186, this.topPos + 68, "modularrouters.guiText.popup.flinger.yaw");
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.blit(GUI_TEXTURE, this.leftPos + 148, this.topPos + 16, LARGE_TEXTFIELD_XY.x(), LARGE_TEXTFIELD_XY.y(), 35, 14);
        graphics.blit(GUI_TEXTURE, this.leftPos + 148, this.topPos + 34, LARGE_TEXTFIELD_XY.x(), LARGE_TEXTFIELD_XY.y(), 35, 14);
        graphics.blit(GUI_TEXTURE, this.leftPos + 148, this.topPos + 52, LARGE_TEXTFIELD_XY.x(), LARGE_TEXTFIELD_XY.y(), 35, 14);
    }

    @Override
    protected void buildComponentPatch(DataComponentPatch.Builder builder) {
        super.buildComponentPatch(builder);
        builder.set(ModDataComponents.FLINGER_SETTINGS.get(), (Object)new CompiledFlingerModule.FlingerSettings(this.speedField.getFloatValue(), this.pitchField.getFloatValue(), this.yawField.getFloatValue()));
    }

    private static class TooltipButton
    extends TexturedButton {
        private final int buttonId;

        TooltipButton(int buttonId, int x, int y, String key, float min, float max) {
            super(x, y, 16, 16, p -> {});
            this.buttonId = buttonId;
            ClientUtil.setMultilineTooltip((AbstractWidget)this, new Component[]{ClientUtil.xlate("modularrouters.guiText.tooltip.flinger." + key, Float.valueOf(min), Float.valueOf(max)).withStyle(ChatFormatting.AQUA), ClientUtil.xlate("modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0])});
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(48 + 16 * this.buttonId, 0);
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }
    }
}

