/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.mojang.serialization.MapCodec;
import com.thevortex.allthemodium.reference.TweakProxy;
import com.thevortex.allthemodium.registry.LevelRegistry;
import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TeleportPad
extends Block {
    MapCodec<? extends TeleportPad> codec = TeleportPad.simpleCodec(TeleportPad::new);
    protected static final VoxelShape TELEPORTPAD_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final BooleanProperty SPAWNED = BooleanProperty.create((String)"spawned");
    private static final ResourceKey<Level> PRECASIA = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aoa3", (String)"precasia"));
    private static final ResourceKey<Level> BARATHOS = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aoa3", (String)"barathos"));
    private static final ResourceKey<Level> ABYSS = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aoa3", (String)"abyss"));
    private static final LinkedHashMap<ResourceKey<Level>, ResourceKey<Level>> DEFAULT_PARTNERS = TeleportPad.buildMap(new LevelPair((ResourceKey<Level>)ServerLevel.OVERWORLD, LevelRegistry.Mining), new LevelPair((ResourceKey<Level>)ServerLevel.NETHER, LevelRegistry.THE_OTHER), new LevelPair((ResourceKey<Level>)ServerLevel.END, LevelRegistry.THE_BEYOND));
    private static final Map<Integer, Map<ResourceKey<Level>, ResourceKey<Level>>> OVERRIDES = Map.of(7, TeleportPad.buildMap(new LevelPair(PRECASIA, LevelRegistry.Mining), new LevelPair(BARATHOS, LevelRegistry.THE_OTHER), new LevelPair(ABYSS, LevelRegistry.THE_BEYOND)));

    public TeleportPad(BlockBehaviour.Properties properties) {
        this(false, properties);
    }

    public TeleportPad(boolean spawned, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SPAWNED, (Comparable)Boolean.valueOf(spawned)));
    }

    private int config() {
        return TeleportPad.isLoaded() ? TweakProxy.packMode() : 0;
    }

    public static boolean isLoaded() {
        return ModList.get().isLoaded("aoa3") && ModList.get().isLoaded("allthetweaks");
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SPAWNED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return TELEPORTPAD_AABB;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return TELEPORTPAD_AABB;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player instanceof ServerPlayer && player.isCrouching()) {
            this.transferPlayer((ServerPlayer)player, pos);
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 0.0, 1.0, 0.0);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return (Boolean)state.getValue((Property)SPAWNED) == false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.allthemodium.teleport_pad").withStyle(ChatFormatting.GRAY));
        TeleportPad.getSorted(this.config()).forEach((a, b) -> tooltipComponents.add((Component)this.dim((ResourceKey<Level>)a).append((Component)Component.literal((String)" \u2194 ").withStyle(ChatFormatting.GRAY)).append((Component)this.dim((ResourceKey<Level>)b))));
    }

    private MutableComponent dim(ResourceKey<Level> dim) {
        return Component.translatable((String)String.join((CharSequence)".", dim.registry().getPath(), dim.location().getNamespace(), dim.location().getPath())).withStyle(ChatFormatting.YELLOW);
    }

    public void transferPlayer(ServerPlayer player, BlockPos pos) {
        ServerLevel targetLevel = player.server.getLevel(TeleportPad.getPartner((ResourceKey<Level>)player.level().dimension(), this.config()));
        if (targetLevel == null) {
            return;
        }
        BlockPos targetPos = this.findSafeExit(targetLevel, pos);
        this.teleport(player, targetLevel, targetPos);
    }

    private BlockPos findSafeExit(ServerLevel level, BlockPos entryPos) {
        Optional<BlockPos> existing = this.findClosestTeleportPad(level, entryPos, 32, level.getWorldBorder());
        if (existing.isPresent()) {
            return existing.get();
        }
        for (BlockPos.MutableBlockPos candidate : BlockPos.spiralAround((BlockPos)entryPos, (int)32, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            BlockPos spot;
            if (!level.getWorldBorder().isWithinBounds((BlockPos)candidate)) continue;
            int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, candidate.getX(), candidate.getZ());
            if (level.dimensionType().hasCeiling()) {
                y = this.findSafeY(level, candidate.getX(), y, candidate.getZ(), candidate);
            }
            if (!this.isSafeSpot(level, spot = new BlockPos(candidate.getX(), y, candidate.getZ()))) continue;
            level.setBlockAndUpdate(spot, (BlockState)((Block)ModRegistry.TELEPORT_PAD.get()).defaultBlockState().setValue((Property)SPAWNED, (Comparable)Boolean.valueOf(true)));
            return spot;
        }
        level.setBlockAndUpdate(entryPos, (BlockState)((Block)ModRegistry.TELEPORT_PAD.get()).defaultBlockState().setValue((Property)SPAWNED, (Comparable)Boolean.valueOf(true)));
        return entryPos;
    }

    private int findSafeY(ServerLevel level, int x, int y, int z, BlockPos.MutableBlockPos pos) {
        int minY = level.getMinBuildHeight();
        pos.set(x, y - 1, z);
        pos.move(Direction.DOWN);
        while (pos.getY() > minY) {
            if (this.isSafeSpot(level, pos.immutable())) {
                return pos.getY();
            }
            pos.move(Direction.DOWN);
        }
        return level.getChunkSource().getGenerator().getSpawnHeight(level.getChunk((BlockPos)pos).getHeightAccessorForGeneration());
    }

    private boolean isSafeSpot(ServerLevel level, BlockPos pos) {
        BlockState here = level.getBlockState(pos);
        FluidState hereFluid = level.getFluidState(pos);
        BlockState below = level.getBlockState(pos.below());
        FluidState belowFluid = level.getFluidState(pos.below());
        BlockState above = level.getBlockState(pos.above());
        FluidState aboveFluid = level.getFluidState(pos.above());
        return !(!here.isAir() && !here.is(BlockTags.REPLACEABLE) || !hereFluid.isEmpty() || !above.isAir() && !above.is(BlockTags.REPLACEABLE) || !aboveFluid.isEmpty() || below.isAir() || below.is(BlockTags.REPLACEABLE) || below.is(Blocks.BEDROCK) || !belowFluid.isEmpty());
    }

    public Optional<BlockPos> findClosestTeleportPad(ServerLevel level, BlockPos origin, int radius, WorldBorder border) {
        PoiManager poiManager = level.getPoiManager();
        poiManager.ensureLoadedAndValid((LevelReader)level, origin, radius);
        return poiManager.getInSquare(record -> record.is(ModRegistry.TELEPORT_PAD_POI), origin, radius, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(arg_0 -> ((WorldBorder)border).isWithinBounds(arg_0)).filter(pos -> level.getBlockState(pos).is(ModRegistry.TELEPORT_PAD)).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)origin)).thenComparingInt(Vec3i::getY));
    }

    private void teleport(ServerPlayer player, ServerLevel level, BlockPos targetPos) {
        level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), 0.0, 1.0, 0.0);
        player.teleportTo(level, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.25, (double)targetPos.getZ() + 0.5, player.rotA, player.yya);
    }

    @Nullable
    public static ResourceKey<Level> getPartner(ResourceKey<Level> level, int packMode) {
        Map map = OVERRIDES.getOrDefault(packMode, DEFAULT_PARTNERS);
        return (ResourceKey)map.get(level);
    }

    private static LinkedHashMap<ResourceKey<Level>, ResourceKey<Level>> buildMap(LevelPair ... pairs) {
        LinkedHashMap<ResourceKey<Level>, ResourceKey<Level>> m = new LinkedHashMap<ResourceKey<Level>, ResourceKey<Level>>();
        for (LevelPair p : pairs) {
            m.put(p.a, p.b);
            m.put(p.b, p.a);
        }
        return m;
    }

    private static LinkedHashMap<ResourceKey<Level>, ResourceKey<Level>> getSorted(int config) {
        LinkedHashMap<ResourceKey<Level>, ResourceKey<Level>> copy = new LinkedHashMap<ResourceKey<Level>, ResourceKey<Level>>((Map)OVERRIDES.getOrDefault(config, DEFAULT_PARTNERS));
        Iterator it = copy.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            it.next();
            if (i % 2 == 1) {
                it.remove();
            }
            ++i;
        }
        return copy;
    }

    public record LevelPair(ResourceKey<Level> a, ResourceKey<Level> b) {
    }
}

