/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.thevortex.allthemodium.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AncientLeaves
extends LeavesBlock {
    public static final int DECAY_DISTANCE = 7;
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int TICK_DELAY = 800;
    private static int TICK_COUNT;

    public AncientLeaves(BlockBehaviour.Properties p_54422_) {
        super(p_54422_.randomTicks().noCollission());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getBlockSupportShape(BlockState p_54456_, BlockGetter p_54457_, BlockPos p_54458_) {
        return Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState p_54449_) {
        return (Integer)p_54449_.getValue((Property)DISTANCE) == 7 && (Boolean)p_54449_.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource p_54429_) {
        if (++TICK_COUNT >= 800) {
            level.setBlock(pos, AncientLeaves.updateDistance(state, (LevelAccessor)level, pos), 3);
            if (level.getBlockState(pos.below()).isAir()) {
                level.setBlock(pos.below(), ((Block)ModRegistry.ANCIENT_LEAVES_BOTTOM.get()).defaultBlockState(), 3);
            }
            TICK_COUNT = 0;
        }
    }

    public int getLightBlock(BlockState p_54460_, BlockGetter p_54461_, BlockPos p_54462_) {
        return 1;
    }

    public BlockState updateShape(BlockState p_54440_, Direction p_54441_, BlockState p_54442_, LevelAccessor p_54443_, BlockPos p_54444_, BlockPos p_54445_) {
        int i = AncientLeaves.getDistanceAt(p_54442_) + 1;
        if (i != 1 || (Integer)p_54440_.getValue((Property)DISTANCE) != i) {
            p_54443_.scheduleTick(p_54444_, (Block)this, 1);
        }
        return p_54440_;
    }

    private static BlockState updateDistance(BlockState p_54436_, LevelAccessor p_54437_, BlockPos p_54438_) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_54438_, direction);
            i = Math.min(i, AncientLeaves.getDistanceAt(p_54437_.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)p_54436_.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState p_54464_) {
        if (p_54464_.is(BlockTags.LOGS)) {
            return 0;
        }
        return p_54464_.getBlock() instanceof LeavesBlock ? (Integer)p_54464_.getValue((Property)DISTANCE) : 7;
    }

    public void animateTick(BlockState p_54431_, Level p_54432_, BlockPos p_54433_, RandomSource p_54434_) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!p_54432_.isRainingAt(p_54433_.above()) || p_54434_.nextInt(15) != 1 || (blockstate = p_54432_.getBlockState(blockpos = p_54433_.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)p_54432_, blockpos, Direction.UP))) {
            double d0 = (double)p_54433_.getX() + p_54434_.nextDouble();
            double d1 = (double)p_54433_.getY() - 0.05;
            double d2 = (double)p_54433_.getZ() + p_54434_.nextDouble();
            p_54432_.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54447_) {
        p_54447_.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_54424_) {
        return AncientLeaves.updateDistance((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)p_54424_.getLevel(), p_54424_.getClickedPos());
    }
}

