/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.compatibility.CompatibilityIris;
import ovh.corail.tombstone.registry.ClientModEvents;

@OnlyIn(value=Dist.CLIENT)
public class ParticleRenderTypes {
    public static final ParticleRenderType SOUL = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.SOUL);
        }

        public String toString() {
            return "TB_SOUL";
        }
    };
    public static final ParticleRenderType GHOST = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.GHOST);
        }

        public String toString() {
            return "TB_GHOST";
        }
    };
    public static final ParticleRenderType SMOKE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.SMOKE);
        }

        public String toString() {
            return "TB_SMOKE";
        }
    };
    public static final ParticleRenderType WING = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.WING);
        }

        public String toString() {
            return "TB_WING";
        }
    };
    public static final ParticleRenderType GLOW = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.GLOW);
        }

        public String toString() {
            return "TB_GLOW";
        }
    };
    public static final ParticleRenderType NOTE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.NOTE);
        }

        public String toString() {
            return "TB_NOTE";
        }
    };
    public static final ParticleRenderType AURA = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.AURA);
        }

        public String toString() {
            return "TB_AURA";
        }
    };
    public static final ParticleRenderType CASTING = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.alpha(tesselator, Textures.CASTING);
        }

        public String toString() {
            return "TB_CASTING";
        }
    };
    public static final ParticleRenderType HEART = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.solid(tesselator, Textures.HEART);
        }

        public String toString() {
            return "TB_HEART";
        }
    };
    public static final ParticleRenderType SHIELD = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.solid(tesselator, Textures.SHIELD);
        }

        public String toString() {
            return "TB_SHIELD";
        }
    };
    public static final ParticleRenderType BONE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.solid(tesselator, Textures.BONE);
        }

        public String toString() {
            return "TB_BONE";
        }
    };
    public static final ParticleRenderType ANKH = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.solid(tesselator, Textures.ANKH);
        }

        public String toString() {
            return "TB_ANKH";
        }
    };
    public static final ParticleRenderType GHAST_TEAR = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.solid(tesselator, Textures.GHAST_TEAR);
        }

        public String toString() {
            return "TB_GHAST_TEAR";
        }
    };
    public static final ParticleRenderType GOLD_HEART = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.solid(tesselator, Textures.GOLD_HEART);
        }

        public String toString() {
            return "TB_GOLD_HEART";
        }
    };
    public static final ParticleRenderType BLACK_NOTE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            return BufferBuilders.solid(tesselator, Textures.NOTE);
        }

        public String toString() {
            return "TB_BLACK_NOTE";
        }
    };

    public static class BufferBuilders {
        private static BufferBuilder alpha(Tesselator tesselator, ResourceLocation texture) {
            if (CompatibilityIris.instance.isShaderEnabled()) {
                CompatibilityIris.instance.setFogShader();
            } else {
                RenderSystem.setShader(ClientModEvents::getLowAlphaShader);
            }
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        private static BufferBuilder solid(Tesselator tesselator, ResourceLocation texture) {
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }
    }

    private static class Textures {
        private static final ResourceLocation SOUL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/soul.png");
        private static final ResourceLocation GHOST = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/ghost.png");
        private static final ResourceLocation SMOKE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/fake_fog.png");
        private static final ResourceLocation WING = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/revive.png");
        private static final ResourceLocation GLOW = ResourceLocation.withDefaultNamespace((String)"textures/particle/glow.png");
        private static final ResourceLocation NOTE = ResourceLocation.withDefaultNamespace((String)"textures/particle/note.png");
        private static final ResourceLocation AURA = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/aura/aura1.png");
        private static final ResourceLocation CASTING = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/casting.png");
        private static final ResourceLocation HEART = ResourceLocation.withDefaultNamespace((String)"textures/particle/heart.png");
        private static final ResourceLocation SHIELD = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/pray_of_protection.png");
        private static final ResourceLocation BONE = ResourceLocation.withDefaultNamespace((String)"textures/item/bone.png");
        private static final ResourceLocation ANKH = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/ankh.png");
        private static final ResourceLocation GHAST_TEAR = ResourceLocation.withDefaultNamespace((String)"textures/item/ghast_tear.png");
        private static final ResourceLocation GOLD_HEART = ResourceLocation.withDefaultNamespace((String)"textures/particle/gold_heart.png");

        private Textures() {
        }
    }
}

