/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.particle.CustomParticle;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;
import ovh.corail.tombstone.particle.ParticleRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleGraveSoul
extends CustomParticle {
    private static final double RADIUS = 0.3;
    private static final double SECTION = 1.5707963705062866;
    private final double centerX;
    private final double centerY;
    private final double centerZ;
    private final int part;

    public ParticleGraveSoul(ClientLevel level, double centerX, double centerY, double centerZ, int soulTypeId, int part) {
        super(level, centerX, centerY, centerZ);
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.part = part;
        this.setLifetime(25);
        this.scale(soulTypeId > 1 ? 0.2f : 0.15f);
        this.withColor(SoulType.byId(soulTypeId).getColorCode());
        this.setAlpha(0.5f);
        this.updatePosition();
        this.updateLastPos();
    }

    @Override
    protected void updatePosition() {
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        double ratio = (double)this.age / (double)this.lifetime;
        Vec3 vec = new Vec3(this.centerX + 0.3 * Math.cos(1.5707963705062866 * (ratio + (double)this.part)), this.centerY, this.centerZ + 0.3 * Math.sin(1.5707963705062866 * (ratio + (double)this.part)));
        this.setPos(vec.x, vec.y, vec.z);
    }

    @Override
    public void update() {
        super.update();
        Minecraft.getInstance().particleEngine.add((Particle)new ParticleBlinkingAura(this.level, this.x, this.y + 0.02, this.z, this.rCol, this.gCol, this.bCol));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.SOUL;
    }
}

