/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

public record CMessagePrayer(int entityId, UUID prayerUUID, int prayType, int leftTime) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessagePrayer> STREAM_CODEC = StreamCodec.ofMember(CMessagePrayer::encode, CMessagePrayer::decode);
    static final CustomPacketPayload.Type<CMessagePrayer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"prayer"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessagePrayer decode(RegistryFriendlyByteBuf buf) {
        return new CMessagePrayer(buf.readVarInt(), buf.readUUID(), buf.readShort(), buf.readInt());
    }

    static void encode(CMessagePrayer msg, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(msg.entityId);
        buf.writeUUID(msg.prayerUUID);
        buf.writeShort(msg.prayType);
        buf.writeInt(msg.leftTime);
    }

    static void handle(CMessagePrayer msg, IPayloadContext ctx) {
        Level level = ProxyHelper.getClientWorld().orElse(null);
        if (level != null) {
            CompoundTag tag;
            Player prayer = level.getPlayerByUUID(msg.prayerUUID);
            LivingEntity target = Optional.ofNullable(level.getEntity(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).orElse(null);
            if (prayer != null && target != null && !(tag = target.getPersistentData()).hasUUID("prayer")) {
                tag.putUUID("prayer", msg.prayerUUID);
                EffectHelper.addEffect(target, ModEffects.prayer, msg.leftTime);
                ProxyHelper.producePray(target, msg.prayType, e -> !target.getPersistentData().hasUUID("prayer") || !prayer.isUsingItem() || !prayer.getMainHandItem().is((Item)ModItems.ankh_of_prayer));
            }
        }
    }
}

