/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfRecall
extends ItemTablet {
    public ItemTabletOfRecall() {
        super("tablet_of_recall", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfRecall.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        boolean isAncient = this.isAncient(stack);
        if (isAncient) {
            this.addItemDesc(tooltip, "_ancient", new Object[0]);
        }
        if (!this.isEnchanted(stack)) {
            this.addItemUse(tooltip, "1", new Object[0]);
        } else {
            this.addItemPosition(tooltip, this.getTombPos(stack));
            this.addItemUse(tooltip, "2", new Object[0]);
            this.addItemUse(tooltip, "3", new Object[0]);
        }
        super.addTooltipInfo(stack, context, tooltip);
    }

    private void setTombPos(ItemStack stack, Location location) {
        stack.set(ModDataComponents.LOCATION, (Object)location.asGlobalPos());
    }

    public Location getTombPos(ItemStack stack) {
        return ModDataComponents.getLocation(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return !this.getTombPos(stack).isOrigin();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        this.setTombPos(stack, new Location(gravePos, level));
        if (!this.isAncient(stack) && soulStrength > 1) {
            stack.set(ModDataComponents.ANCIENT, (Object)true);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), 2);
        }
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), 1);
    }

    @Override
    public boolean onSneakGrave(ServerLevel serverLevel, BlockPos gravePos, ServerPlayer serverPlayer, ItemStack stack) {
        if (this.isEnchanted(stack) && EntityHelper.noGlobalItemCooldown((Player)serverPlayer, this)) {
            this.setTombPos(stack, new Location(gravePos, (Level)serverLevel));
            EntityHelper.setGlobalItemCooldown((Player)serverPlayer, this, 100);
            LangKey.sendSystemMessage((Player)serverPlayer, (Component)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), StyleType.MESSAGE_NORMAL);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((Level)world)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        MinecraftServer server = Objects.requireNonNull(player.getServer());
        ServerLevel targetWorld = server.getLevel(location.dim);
        if (!WorldHelper.isValidPos((Level)targetWorld, location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        Location spawnPos = new SpawnHelper(targetWorld, location.move(Direction.UP, 1).getPos()).findSpawnPlace();
        if (spawnPos.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((Player)player, new Object[0]);
            return false;
        }
        CallbackHandler.addFastCallback(() -> {
            boolean isAncient = this.isAncient(stack);
            ServerPlayer newPlayer = Helper.teleport(player, spawnPos, targetWorld);
            if (isAncient) {
                Location home = new Location((Entity)newPlayer);
                world.getEntities((Entity)player, player.getBoundingBox().inflate(3.0, 0.0, 3.0), e -> e.isAlive() && e.canChangeDimensions(e.level(), newPlayer.level()) && !e.isSpectator()).forEach(entity -> Helper.teleport(entity, home, targetWorld));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
            ModTriggers.use_recall.trigger(player);
        });
        return true;
    }

    @Override
    protected CastingType getCastingType(ItemStack stack) {
        return this.isAncient(stack) ? CastingType.AREA_TELEPORT : CastingType.SIMPLE_TELEPORT;
    }
}

