/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

public class ItemChristmasGift
extends ItemGeneric
implements ISoulConsumer {
    public ItemChristmasGift() {
        super("christmas_gift", ItemChristmasGift.getBuilder().stacksTo(1).fireResistant());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        if (LocalDate.now().get(ChronoField.DAY_OF_MONTH) >= 25) {
            this.addItemUse(tooltip);
        }
        super.addTooltipInfo(stack, context, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (stack.is((Item)this) && !TimeHelper.isDateAroundChristmas()) {
            stack.shrink(stack.getCount());
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (TimeHelper.isDateAroundChristmas() && LocalDate.now().get(ChronoField.DAY_OF_MONTH) >= 25) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.essence_of_undeath));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.gemstone_of_merchant));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.gemstone_of_guardian));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.gemstone_of_familiar));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.gemstone_of_prayer));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, ModPotions.earthly_garden));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, ModPotions.little_world));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, ModPotions.giant_strength));
            player.giveExperiencePoints(1000);
            stack.shrink(1);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_GIFT_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_GIFT_FAILED.getText(new Object[0]));
    }

    @Override
    public int getKnowledge() {
        return 10;
    }

    @Override
    public int getCorruptionLevel(ItemStack stack) {
        return 0;
    }
}

