/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.IImpregnable;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModDataComponents;

public interface IDefaultImpregnable
extends IImpregnable {
    @Override
    default public String getEntityType(ItemStack stack) {
        return stack.getItem() == this ? (String)stack.getOrDefault(ModDataComponents.ENTITY_TYPE, (Object)"") : "";
    }

    @Override
    default public ItemStack impregnate(ItemStack stack, String entityType) {
        if (stack.getItem() == this) {
            stack.set(ModDataComponents.ENTITY_TYPE, (Object)entityType);
        }
        return stack;
    }

    @Override
    default public boolean impregnate(ItemStack stack, @Nullable LivingEntity entity) {
        ResourceLocation registryName;
        if (entity != null && stack.getItem() == this && this.getEntityType(stack).isEmpty() && (registryName = RegistryHelper.getRegistryName(entity.getType())) != null) {
            stack.set(ModDataComponents.ENTITY_TYPE, (Object)registryName.toString());
            return true;
        }
        return false;
    }

    @Override
    default public boolean isImpregnated(ItemStack stack) {
        return stack.getItem() == this && !((String)stack.getOrDefault(ModDataComponents.ENTITY_TYPE, (Object)"")).isEmpty();
    }

    @Override
    @Nullable
    default public Component getTooltipDisplay(ItemStack stack) {
        String id = this.getEntityType(stack);
        return id.isEmpty() ? null : LangKey.MESSAGE_IMPREGNATE.getText(StyleType.TOOLTIP_ENCHANT, new Object[]{LangKey.getEntityName(id)});
    }
}

