/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.CompatibilityDragonSurvival;
import ovh.corail.tombstone.compatibility.CompatibilityEnigmatic;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.RegistryHelper;

public final class InventoryHelper {
    private static final IItemHandler EMPTY_ITEM_HANDLER = new ItemStackHandler(NonNullList.create());

    public static void autoequip(ServerPlayer player, ItemStackHandler itemHandler, Item lastOffhandItem) {
        Predicate<ItemStack> filter = stack -> lastOffhandItem != Items.AIR ? stack.is(lastOffhandItem) || InventoryHelper.getStackFilter(player).test((ItemStack)stack) : InventoryHelper.getStackFilter(player).test((ItemStack)stack);
        List<Integer> itemIds = IntStream.range(0, itemHandler.getSlots()).filter(i -> filter.test(itemHandler.getStackInSlot(i))).mapToObj(Integer.class::cast).collect(Collectors.toList());
        if (((Boolean)ConfigTombstone.compatibility.curioAutoEquip.get()).booleanValue() && SupportMods.CURIOS.isLoaded()) {
            CompatibilityCurio.instance.autoEquip(player, itemHandler, itemIds);
        }
        ListIterator idIterator = itemIds.listIterator(itemIds.size());
        while (idIterator.hasPrevious()) {
            int slotId = (Integer)idIterator.previous();
            if (!InventoryHelper.autoequip(itemHandler.getStackInSlot(slotId), player, lastOffhandItem)) continue;
            itemHandler.setStackInSlot(slotId, ItemStack.EMPTY);
        }
    }

    private static Predicate<ItemStack> getStackFilter(ServerPlayer player) {
        Predicate<ItemStack> predic = stack -> !stack.isEmpty() && !EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && stack.getMaxStackSize() == 1;
        if (SupportMods.ENIGMATIC_LEGACY.isLoaded()) {
            predic = predic.and(stack -> !CompatibilityEnigmatic.instance.isDenied((ItemStack)stack));
        }
        if (SupportMods.POWERSUITS.isLoaded()) {
            predic = predic.and(stack -> !RegistryHelper.isValid(stack.getItem(), rl -> "powersuits".equals(rl.getNamespace())));
        }
        return predic;
    }

    private static boolean autoequip(ItemStack stack, ServerPlayer player, Item lastOffhandItem) {
        if (SupportMods.DRAGON_SURVIVAL.isLoaded() && CompatibilityDragonSurvival.instance.autoEquip(stack, (Player)player)) {
            return true;
        }
        @Nullable EquipmentSlot slot = InventoryHelper.getEquipmentSlot(stack);
        if (lastOffhandItem != Items.AIR ? stack.is(lastOffhandItem) : slot == EquipmentSlot.OFFHAND) {
            ItemStack offhandStack = player.getOffhandItem();
            if (offhandStack.isEmpty()) {
                player.getInventory().offhand.set(0, (Object)stack.copy());
                return true;
            }
            if (!PlayerPreference.get(player).equipShieldInPriority() && !offhandStack.is(lastOffhandItem)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)offhandStack.copy());
                player.getInventory().offhand.set(0, (Object)stack.copy());
                return true;
            }
            return false;
        }
        if (slot == null || slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.BODY) {
            return false;
        }
        ItemStack stackInSlot = player.getItemBySlot(slot);
        if (slot == EquipmentSlot.OFFHAND) {
            if (PlayerPreference.get(player).equipShieldInPriority() && InventoryHelper.isShield(stack) && !InventoryHelper.isShield(stackInSlot)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.copy());
                player.getInventory().offhand.set(0, (Object)stack.copy());
                return true;
            }
            return false;
        }
        int slotId = slot.getIndex();
        if (stackInSlot.isEmpty()) {
            player.getInventory().armor.set(slotId, (Object)stack.copy());
            return true;
        }
        if (slot == EquipmentSlot.CHEST && PlayerPreference.get(player).equipElytraInPriority() && InventoryHelper.isElytra(stack) && !InventoryHelper.isElytra(stackInSlot)) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.copy());
            player.getInventory().armor.set(slotId, (Object)stack.copy());
            return true;
        }
        return false;
    }

    @Nullable
    private static EquipmentSlot getEquipmentSlot(ItemStack stack) {
        @Nullable EquipmentSlot slot = Optional.ofNullable(stack.getItem().getEquipmentSlot(stack)).orElse(Optional.ofNullable(Equipable.get((ItemStack)stack)).map(Equipable::getEquipmentSlot).orElse(null));
        return Optional.ofNullable(slot).filter(s -> s.getType() != EquipmentSlot.Type.ANIMAL_ARMOR).orElse(null);
    }

    private static boolean isElytra(ItemStack stack) {
        return stack.getItem() instanceof ElytraItem;
    }

    private static boolean isShield(ItemStack stack) {
        return stack.getItem().canPerformAction(stack, ItemAbilities.SHIELD_BLOCK);
    }

    public static boolean isToolOrMelee(ItemStack stack) {
        return !stack.isEmpty() && stack.getMaxStackSize() == 1 && (stack.getItem() instanceof TieredItem || stack.getItem() instanceof FishingRodItem || stack.getItem() instanceof ShearsItem || stack.getItem() instanceof TridentItem || stack.getItem() instanceof MaceItem);
    }

    public static IItemHandler getItemHandler(Entity entity) {
        return Optional.ofNullable((IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY)).orElse(EMPTY_ITEM_HANDLER);
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Item item) {
        return InventoryHelper.findFirstInInventory(player, (ItemStack stack) -> stack.is(item));
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Predicate<ItemStack> predic) {
        if (player != null) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            return IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(predic).findFirst().orElse(ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }

    public static boolean removeFirstInInventory(Player player, Predicate<ItemStack> predic) {
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!predic.test(stack)) continue;
            itemHandler.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static boolean hasEnoughSlots(IItemHandler itemHandler, int count) {
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.getStackInSlot(i).isEmpty() || ++found < count) continue;
            return true;
        }
        return false;
    }
}

