/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.SpellCasterHandler;

public abstract class SpellUseGoal
extends Goal {
    protected final PathfinderMob caster;
    protected int attackWarmupDelay;
    protected int nextAttackTickCount;

    protected SpellUseGoal(PathfinderMob caster) {
        this.caster = caster;
    }

    public boolean canUse() {
        return this.caster.onGround() && !this.caster.isInFluidType() && this.caster.tickCount >= this.nextAttackTickCount && !SpellCasterHandler.hasSpellCooldown((LivingEntity)this.caster) && !SpellCasterHandler.isCasting((LivingEntity)this.caster);
    }

    public boolean canContinueToUse() {
        return this.caster.onGround() && !this.caster.isInFluidType() && this.attackWarmupDelay > 0;
    }

    public void start() {
        this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
        SpellCasterHandler.startCasting((LivingEntity)this.caster, this.getCastingTime(), this.getSpellColor());
        this.nextAttackTickCount = this.caster.tickCount + this.getCastingInterval();
    }

    public void tick() {
        --this.attackWarmupDelay;
        if (this.attackWarmupDelay == 0) {
            this.performSpellCasting();
            Optional.ofNullable(this.getSpellPrepareSound()).ifPresent(c -> this.caster.playSound(c, 1.0f, 1.0f));
        }
    }

    public void stop() {
        if (this.attackWarmupDelay > 0) {
            this.nextAttackTickCount = this.caster.tickCount;
        }
    }

    protected abstract void performSpellCasting();

    protected abstract int getCastWarmupTime();

    protected abstract int getCastingTime();

    protected abstract int getCastingInterval();

    @Nullable
    protected abstract SoundEvent getSpellPrepareSound();

    protected abstract int getSpellColor();
}

