/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public abstract class OwnerHurtByTargetGoal
extends TargetGoal {
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public OwnerHurtByTargetGoal(Mob servant) {
        super(servant, false);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        return this.getOwner().map(owner -> {
            this.ownerLastHurtBy = owner.getLastHurtByMob();
            int lastHurtByTimestamp = owner.getLastHurtByMobTimestamp();
            if (this.timestamp != lastHurtByTimestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT)) {
                this.timestamp = lastHurtByTimestamp;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        this.mob.setLastHurtByMob(this.ownerLastHurtBy);
        super.start();
    }

    protected abstract Optional<Player> getOwner();
}

