/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StorageHelper;
import ovh.corail.tombstone.helper.StyleType;

public final class CommandTBRecovery
extends TombstoneCommand {
    private final SuggestionProvider<CommandSourceStack> SUGGESTION_PLAYER_SAVES = (ctx, build) -> {
        File[] matchingFiles;
        File checkedFile;
        String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
        GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)ctx.getSource()).getServer(), playerName);
        List<Object> list = new ArrayList();
        if (profil != null && (checkedFile = new File(StorageHelper.getSavedPlayerFolder(((CommandSourceStack)ctx.getSource()).getServer()), profil.getId().toString())).exists() && (matchingFiles = checkedFile.listFiles((file, name) -> name.endsWith(".save"))) != null) {
            list = Arrays.stream(matchingFiles).map(p -> p.getName().replace(".save", "")).collect(Collectors.toList());
            list.add(".latest");
            list.add(".oldest");
        }
        return SharedSuggestionProvider.suggest(list, (SuggestionsBuilder)build);
    };
    private final SuggestionProvider<CommandSourceStack> SUGGESTION_SAVED_PLAYERS = (ctx, build) -> {
        File[] matchingFiles;
        ArrayList<String> list = new ArrayList<String>();
        File checkedFile = StorageHelper.getSavedPlayerFolder(((CommandSourceStack)ctx.getSource()).getServer());
        if (checkedFile.exists() && (matchingFiles = checkedFile.listFiles((file, name) -> file.isDirectory())) != null) {
            for (File file2 : matchingFiles) {
                try {
                    UUID uuid = UUID.fromString(file2.getName());
                    GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)ctx.getSource()).getServer(), uuid);
                    if (profil == null) continue;
                    list.add(profil.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return SharedSuggestionProvider.suggest(list, (SuggestionsBuilder)build);
    };

    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.RECOVERY;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildContext) {
        builder.executes(this::showUsage);
        builder.then(SubCommand.SAVE_ALL_PLAYERS.literal().executes(c -> CommandTBRecovery.saveAllPlayers(((CommandSourceStack)c.getSource()).getServer(), success -> this.sendMessage((CommandSourceStack)c.getSource(), (success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).getText(new Object[0]), true))));
        builder.then(((LiteralArgumentBuilder)SubCommand.SAVE_PLAYER.literal().executes(this::showUsage)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(c -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)c, (String)"player");
            return CommandTBRecovery.savePlayer(player, success -> this.sendMessage((CommandSourceStack)c.getSource(), (success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.getName()), false));
        })));
        builder.then(((LiteralArgumentBuilder)SubCommand.LOAD_PLAYER.literal().executes(this::showUsage)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this.SUGGESTION_SAVED_PLAYERS).executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"player");
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
            if (player != null) {
                return this.loadPlayer((CommandSourceStack)c.getSource(), player, ".latest");
            }
            GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)c.getSource()).getServer(), playerName);
            if (profil == null) {
                throw EntityArgument.ERROR_ONLY_PLAYERS_ALLOWED.create();
            }
            return this.recoverPlayerOffline((CommandSourceStack)c.getSource(), profil, ".latest");
        })).then(Commands.argument((String)"file_string", (ArgumentType)StringArgumentType.word()).suggests(this.SUGGESTION_PLAYER_SAVES).executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"player");
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
            if (player != null) {
                return this.loadPlayer((CommandSourceStack)c.getSource(), player, StringArgumentType.getString((CommandContext)c, (String)"file_string"));
            }
            GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)c.getSource()).getServer(), playerName);
            if (profil == null) {
                throw EntityArgument.ERROR_ONLY_PLAYERS_ALLOWED.create();
            }
            return this.recoverPlayerOffline((CommandSourceStack)c.getSource(), profil, StringArgumentType.getString((CommandContext)c, (String)"file_string"));
        }))));
        return builder;
    }

    public static int saveAllPlayers(MinecraftServer server, BooleanConsumer consumer) {
        File baseFolder = StorageHelper.getSavedPlayerFolder(server);
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            ModTombstone.LOGGER.warn("The backup folder for players cannot be created");
            consumer.accept(false);
            return 1;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        boolean hasPlayerSkipped = false;
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!player.isAlive() || player.isSpectator()) continue;
            File playerFolder = CommandTBRecovery.getPlayerFolder(player);
            if (playerFolder == null) {
                hasPlayerSkipped = true;
                continue;
            }
            pairs.add(Pair.of((Object)player.saveWithoutId(new CompoundTag()), (Object)playerFolder));
        }
        if (pairs.isEmpty()) {
            consumer.accept(true);
            return 1;
        }
        boolean skipped = hasPlayerSkipped;
        BackupService.get().execute(() -> {
            boolean wasSuccessful = !skipped;
            for (Pair pair : pairs) {
                boolean success = CommandTBRecovery.savePlayerData((CompoundTag)pair.getLeft(), (File)pair.getRight());
                if (success) continue;
                wasSuccessful = false;
            }
            boolean isSuccessful = wasSuccessful;
            server.submitAsync(() -> consumer.accept(isSuccessful));
        });
        return 1;
    }

    public static int savePlayer(ServerPlayer player, BooleanConsumer consumer) throws CommandSyntaxException {
        CommandTBRecovery.checkAlive((Entity)player);
        CommandTBRecovery.checkNotSpectator((Entity)player);
        File playerFolder = CommandTBRecovery.getPlayerFolder(player);
        if (playerFolder == null) {
            consumer.accept(false);
            return 1;
        }
        MinecraftServer listener = player.level().getServer();
        CompoundTag tag = player.saveWithoutId(new CompoundTag());
        BackupService.get().execute(() -> CommandTBRecovery.lambda$savePlayer$9(tag, playerFolder, (BlockableEventLoop)listener, consumer));
        return 1;
    }

    private static boolean savePlayerData(CompoundTag tag, File saveFolder) {
        String dateString = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(new Date());
        if (StorageHelper.save(new File(saveFolder, dateString + ".save"), tag)) {
            File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
            if (matchingFiles != null && matchingFiles.length > (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get()) {
                int diff = matchingFiles.length - (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get();
                Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                int num = 0;
                for (File file2 : matchingFiles) {
                    if (num >= diff) break;
                    file2.delete();
                    ++num;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static File getPlayerFolder(ServerPlayer player) {
        File saveFolder = new File(StorageHelper.getSavedPlayerFolder(player.server), String.valueOf(player.getGameProfile().getId()));
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.warn("The backup folder cannot be created");
            return null;
        }
        return saveFolder;
    }

    private int recoverPlayerOffline(CommandSourceStack sender, GameProfile profil, String fileString) throws CommandSyntaxException {
        ServerPlayer player = EntityHelper.getPlayerForLogin(sender.getServer(), profil);
        CompoundTag nbt = StorageHelper.loadCompound(this.getBackupFile(sender, profil.getId(), fileString));
        if (nbt.isEmpty()) {
            throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.getName());
        }
        player.load(nbt);
        EntityHelper.writePlayerData(sender.getServer(), (Player)player);
        this.sendMessage(sender, LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getText(player.getName()), false);
        return 1;
    }

    private int loadPlayer(CommandSourceStack sender, ServerPlayer player, String fileString) throws CommandSyntaxException {
        ServerLevel targetWorld;
        CommandTBRecovery.checkAlive((Entity)player);
        CommandTBRecovery.checkNotSpectator((Entity)player);
        CompoundTag nbt = StorageHelper.loadCompound(this.getBackupFile(sender, player.getGameProfile().getId(), fileString));
        if (nbt.isEmpty()) {
            throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.getName());
        }
        ResourceKey sourceDim = player.level().dimension();
        ResourceKey targetDim = NBTStackHelper.getWorldKey(nbt, "Dimension");
        MinecraftServer server = sender.getServer();
        if (targetDim == null || (targetWorld = sender.getServer().getLevel(targetDim)) == null) {
            targetDim = Level.OVERWORLD;
            targetWorld = server.overworld();
        }
        ListTag pos = nbt.getList("Pos", 6);
        double x = pos.getDouble(0);
        double y = pos.getDouble(1);
        double z = pos.getDouble(2);
        nbt.remove("Dimension");
        nbt.remove("Pos");
        nbt.remove("Rotation");
        player.deserializeNBT((HolderLookup.Provider)player.level().registryAccess(), nbt);
        Helper.teleport(player, x, y, z, targetWorld);
        if (sourceDim == targetDim) {
            player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
            server.getPlayerList().sendLevelInfo(player, targetWorld);
            server.getPlayerList().sendAllPlayerInfo(player);
            player.getActiveEffects().forEach(e -> player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(player.getId(), e, false)));
            player.lastSentExp = -1;
            player.lastSentHealth = -1.0f;
            player.lastSentFood = -1;
            EventHooks.firePlayerRespawnEvent((ServerPlayer)player, (boolean)false);
        }
        LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_TARGET_SUCCESS.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
        this.sendMessage(sender, LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getText(player.getName()), false);
        return 1;
    }

    private File getBackupFile(CommandSourceStack sender, UUID id, String fileString) throws CommandSyntaxException {
        Object fileName;
        File saveFolder = new File(StorageHelper.getSavedPlayerFolder(sender.getServer()), String.valueOf(id));
        if (!saveFolder.exists()) {
            throw LangKey.MESSAGE_RECOVERY_NO_FOLDER.asCommandException(saveFolder.getAbsolutePath());
        }
        if (fileString.equals(".latest") || fileString.equals(".oldest")) {
            File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
            if (saveFiles == null || saveFiles.length == 0) {
                throw LangKey.MESSAGE_RECOVERY_NO_FILE.asCommandException(fileString);
            }
            Optional<File> res = fileString.equals(".latest") ? Stream.of(saveFiles).max(File::compareTo) : Stream.of(saveFiles).min(File::compareTo);
            fileName = res.get().getName();
        } else {
            fileName = fileString + ".save";
            File[] files = saveFolder.listFiles(arg_0 -> CommandTBRecovery.lambda$getBackupFile$13((String)fileName, arg_0));
            if (files == null || files.length == 0) {
                throw LangKey.MESSAGE_RECOVERY_NO_FILE.asCommandException(fileName);
            }
        }
        return new File(saveFolder, (String)fileName);
    }

    private static /* synthetic */ boolean lambda$getBackupFile$13(String fileName, File p) {
        return p.isFile() && p.getName().equals(fileName);
    }

    private static /* synthetic */ void lambda$savePlayer$9(CompoundTag tag, File playerFolder, BlockableEventLoop listener, BooleanConsumer consumer) {
        boolean result = CommandTBRecovery.savePlayerData(tag, playerFolder);
        listener.submitAsync(() -> consumer.accept(result));
    }

    private static enum SubCommand implements ISubCommand
    {
        SAVE_ALL_PLAYERS,
        SAVE_PLAYER,
        LOAD_PLAYER;

    }
}

