/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory.slot;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class BaseItemStackHandlerSlot
extends SlotItemHandler {
    private final BaseItemStackHandler inventory;
    private final int index;

    public BaseItemStackHandlerSlot(BaseItemStackHandler inventory, int index, int x, int y) {
        super((IItemHandler)inventory, index, x, y);
        this.inventory = inventory;
        this.index = index;
    }

    public boolean mayPickup(Player player) {
        return !this.inventory.extractItem(this.index, 1, true, true).isEmpty();
    }

    public ItemStack remove(int amount) {
        return this.inventory.extractItem(this.index, amount, false, true);
    }

    public int getMaxStackSize(ItemStack stack) {
        int slotLimit = this.inventory.getSlotLimit(this.index);
        if (slotLimit > 64) {
            if (stack.getMaxStackSize() < 64) {
                return (int)((float)slotLimit * (float)stack.getMaxStackSize() / 64.0f);
            }
            return slotLimit;
        }
        return super.getMaxStackSize(stack);
    }
}

