/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory;

import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CachedRecipe<I extends RecipeInput, T extends Recipe<I>> {
    private final RecipeType<T> type;
    private T recipe;

    public CachedRecipe(RecipeType<T> type) {
        this.type = type;
    }

    public boolean check(I inventory, Level level) {
        if (this.recipe != null && this.recipe.matches(inventory, level)) {
            return true;
        }
        this.recipe = level.getRecipeManager().getRecipeFor(this.type, inventory, level).map(RecipeHolder::value).orElse(null);
        return this.recipe != null;
    }

    public boolean exists() {
        return this.recipe != null;
    }

    public T get() {
        return this.recipe;
    }

    public T checkAndGet(I inventory, Level level) {
        if (this.check(inventory, level)) {
            return this.recipe;
        }
        return null;
    }
}

