/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.sound;

import com.blakebr0.ironjetpacks.init.ModSounds;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class JetpackSound
extends AbstractTickableSoundInstance {
    private static final Map<Integer, JetpackSound> PLAYING_FOR = Collections.synchronizedMap(new HashMap());
    private final Player player;

    public JetpackSound(Player player) {
        super((SoundEvent)ModSounds.JETPACK.get(), SoundSource.PLAYERS, player.getRandom());
        this.player = player;
        this.looping = true;
        PLAYING_FOR.put(player.getId(), this);
    }

    public static boolean playing(int entityId) {
        return PLAYING_FOR.containsKey(entityId) && PLAYING_FOR.get(entityId) != null && !PLAYING_FOR.get(entityId).isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Vec3 pos = this.player.position();
        this.x = (float)pos.x();
        this.y = (float)pos.y() - 10.0f;
        this.z = (float)pos.z();
        if (!JetpackUtils.isFlying(this.player)) {
            Map<Integer, JetpackSound> map = PLAYING_FOR;
            synchronized (map) {
                PLAYING_FOR.remove(this.player.getId());
                this.stop();
            }
        }
    }
}

