/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting.layouts;

import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.TextureConnections;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;

public class PiecedLayoutHandler
extends ConnectingTextureLayoutHandler {
    private static final int[] CORNER_SPRITE_INDICES = new int[]{0, 3, 2, 4, 0, 3, 2, 1};

    public PiecedLayoutHandler() {
        super(5, 1, 0, 0, 3);
    }

    @Override
    public boolean processBlockQuad(int quadIndex, MutableQuad quad, ConnectingTextureSprite sprite, TextureConnections connections) {
        float oppositeToLastPercentage;
        float oppositeToNextPercentage;
        float toLastCornerPercentage;
        boolean lastCornerUVSmaller;
        float toNextCornerPercentage;
        boolean nextCornerUVSmaller;
        boolean nextCornerIsSameU;
        int fullSpriteIndex = -1;
        if (!(connections.top || connections.right || connections.bottom || connections.left)) {
            fullSpriteIndex = 0;
        } else if (connections.top && connections.topRight && connections.right && connections.bottomRight && connections.bottom && connections.bottomLeft && connections.left && connections.topLeft) {
            fullSpriteIndex = 1;
        } else if (connections.top && !connections.right && connections.bottom && !connections.left) {
            fullSpriteIndex = 2;
        } else if (!connections.top && connections.right && !connections.bottom && connections.left) {
            fullSpriteIndex = 3;
        } else if (connections.top && !connections.topRight && connections.right && !connections.bottomRight && connections.bottom && !connections.bottomLeft && connections.left && !connections.topLeft) {
            fullSpriteIndex = 4;
        }
        if (fullSpriteIndex != -1) {
            if (quadIndex != 0) {
                return false;
            }
            PiecedLayoutHandler.remapUVFullSprite(quad, fullSpriteIndex, sprite);
            return true;
        }
        float halfU = (sprite.u1 + sprite.u0) / 2.0f;
        float halfV = (sprite.v1 + sprite.v0) / 2.0f;
        int nextCorner = (quadIndex + 1) % 4;
        int oppositeCorner = (quadIndex + 2) % 4;
        int lastCorner = (quadIndex + 3) % 4;
        boolean bl = nextCornerIsSameU = (double)Math.abs(quad.u(nextCorner) - quad.u(quadIndex)) / PiecedLayoutHandler.vertexDistance(quad, quadIndex, nextCorner) < (double)Math.abs(quad.u(lastCorner) - quad.u(quadIndex)) / PiecedLayoutHandler.vertexDistance(quad, quadIndex, lastCorner);
        boolean bl2 = nextCornerIsSameU ? quad.v(nextCorner) < quad.v(quadIndex) : (nextCornerUVSmaller = quad.u(nextCorner) < quad.u(quadIndex));
        float f = nextCornerIsSameU ? (nextCornerUVSmaller ? (quad.v(quadIndex) - halfV) / (quad.v(quadIndex) - quad.v(nextCorner)) : (halfV - quad.v(quadIndex)) / (quad.v(nextCorner) - quad.v(quadIndex))) : (toNextCornerPercentage = nextCornerUVSmaller ? (quad.u(quadIndex) - halfU) / (quad.u(quadIndex) - quad.u(nextCorner)) : (halfU - quad.u(quadIndex)) / (quad.u(nextCorner) - quad.u(quadIndex)));
        if (toNextCornerPercentage <= 0.0f) {
            return false;
        }
        boolean bl3 = nextCornerIsSameU ? quad.u(lastCorner) < quad.u(quadIndex) : (lastCornerUVSmaller = quad.v(lastCorner) < quad.v(quadIndex));
        float f2 = nextCornerIsSameU ? (lastCornerUVSmaller ? (quad.u(quadIndex) - halfU) / (quad.u(quadIndex) - quad.u(lastCorner)) : (halfU - quad.u(quadIndex)) / (quad.u(lastCorner) - quad.u(quadIndex))) : (toLastCornerPercentage = nextCornerUVSmaller ? (quad.v(quadIndex) - halfV) / (quad.v(quadIndex) - quad.v(lastCorner)) : (halfV - quad.v(quadIndex)) / (quad.v(lastCorner) - quad.v(quadIndex)));
        if (toLastCornerPercentage <= 0.0f) {
            return false;
        }
        float f3 = nextCornerIsSameU ? (lastCornerUVSmaller ? (halfU - quad.u(oppositeCorner)) / (quad.u(nextCorner) - quad.u(oppositeCorner)) : (quad.u(oppositeCorner) - halfU) / (quad.u(oppositeCorner) - quad.u(nextCorner))) : (oppositeToNextPercentage = lastCornerUVSmaller ? (halfV - quad.v(oppositeCorner)) / (quad.v(nextCorner) - quad.v(oppositeCorner)) : (quad.v(oppositeCorner) - halfV) / (quad.v(oppositeCorner) - quad.v(nextCorner)));
        float f4 = nextCornerIsSameU ? (nextCornerUVSmaller ? (halfV - quad.v(oppositeCorner)) / (quad.v(lastCorner) - quad.v(oppositeCorner)) : (quad.v(oppositeCorner) - halfV) / (quad.v(oppositeCorner) - quad.v(lastCorner))) : (oppositeToLastPercentage = nextCornerUVSmaller ? (halfU - quad.u(oppositeCorner)) / (quad.u(lastCorner) - quad.u(oppositeCorner)) : (quad.u(oppositeCorner) - halfU) / (quad.u(oppositeCorner) - quad.u(lastCorner)));
        if (oppositeToNextPercentage > 0.0f || oppositeToLastPercentage > 0.0f) {
            float oppositeX = quad.x(oppositeCorner);
            float oppositeY = quad.y(oppositeCorner);
            float oppositeZ = quad.z(oppositeCorner);
            if (oppositeToNextPercentage > 0.0f) {
                oppositeX += (quad.x(nextCorner) - quad.x(oppositeCorner)) * oppositeToNextPercentage;
                oppositeY += (quad.y(nextCorner) - quad.y(oppositeCorner)) * oppositeToNextPercentage;
                oppositeZ += (quad.z(nextCorner) - quad.z(oppositeCorner)) * oppositeToNextPercentage;
            }
            if (oppositeToLastPercentage > 0.0f) {
                oppositeX += (quad.x(lastCorner) - quad.x(oppositeCorner)) * oppositeToLastPercentage;
                oppositeY += (quad.y(lastCorner) - quad.y(oppositeCorner)) * oppositeToLastPercentage;
                oppositeZ += (quad.z(lastCorner) - quad.z(oppositeCorner)) * oppositeToLastPercentage;
            }
            quad.pos(oppositeCorner, oppositeX, oppositeY, oppositeZ);
        }
        if (toNextCornerPercentage < 1.0f) {
            quad.pos(nextCorner, quad.x(quadIndex) + (quad.x(nextCorner) - quad.x(quadIndex)) * toNextCornerPercentage, quad.y(quadIndex) + (quad.y(nextCorner) - quad.y(quadIndex)) * toNextCornerPercentage, quad.z(quadIndex) + (quad.z(nextCorner) - quad.z(quadIndex)) * toNextCornerPercentage);
        }
        if (toLastCornerPercentage < 1.0f) {
            quad.pos(lastCorner, quad.x(quadIndex) + (quad.x(lastCorner) - quad.x(quadIndex)) * toLastCornerPercentage, quad.y(quadIndex) + (quad.y(lastCorner) - quad.y(quadIndex)) * toLastCornerPercentage, quad.z(quadIndex) + (quad.z(lastCorner) - quad.z(quadIndex)) * toLastCornerPercentage);
        }
        float uOffset = (sprite.getU1() - sprite.getU0()) * (float)PiecedLayoutHandler.getTileIndex(nextCornerIsSameU ? !nextCornerUVSmaller : !lastCornerUVSmaller, nextCornerIsSameU ? !lastCornerUVSmaller : !nextCornerUVSmaller, connections);
        if (oppositeToNextPercentage > 0.0f || oppositeToLastPercentage > 0.0f) {
            float oppositeU = quad.u(oppositeCorner);
            float oppositeV = quad.v(oppositeCorner);
            if (oppositeToNextPercentage > 0.0f) {
                oppositeU += (quad.u(nextCorner) - quad.u(oppositeCorner)) * oppositeToNextPercentage;
                oppositeV += (quad.v(nextCorner) - quad.v(oppositeCorner)) * oppositeToNextPercentage;
            }
            if (oppositeToLastPercentage > 0.0f) {
                oppositeU += (quad.u(lastCorner) - quad.u(oppositeCorner)) * oppositeToLastPercentage;
                oppositeV += (quad.v(lastCorner) - quad.v(oppositeCorner)) * oppositeToLastPercentage;
            }
            quad.uv(oppositeCorner, oppositeU + uOffset, oppositeV);
        } else {
            quad.uv(oppositeCorner, quad.u(oppositeCorner) + uOffset, quad.v(oppositeCorner));
        }
        if (toNextCornerPercentage < 1.0f) {
            quad.uv(nextCorner, quad.u(quadIndex) + (quad.u(nextCorner) - quad.u(quadIndex)) * toNextCornerPercentage + uOffset, quad.v(quadIndex) + (quad.v(nextCorner) - quad.v(quadIndex)) * toNextCornerPercentage);
        } else {
            quad.uv(nextCorner, quad.u(nextCorner) + uOffset, quad.v(nextCorner));
        }
        if (toLastCornerPercentage < 1.0f) {
            quad.uv(lastCorner, quad.u(quadIndex) + (quad.u(lastCorner) - quad.u(quadIndex)) * toLastCornerPercentage + uOffset, quad.v(quadIndex) + (quad.v(lastCorner) - quad.v(quadIndex)) * toLastCornerPercentage);
        } else {
            quad.uv(lastCorner, quad.u(lastCorner) + uOffset, quad.v(lastCorner));
        }
        quad.uv(quadIndex, quad.u(quadIndex) + uOffset, quad.v(quadIndex));
        return true;
    }

    private static int getTileIndex(boolean top, boolean left, TextureConnections connections) {
        int index = top ? (left ? (connections.left ? 1 : 0) | (connections.top ? 1 : 0) << 1 | (connections.topLeft ? 1 : 0) << 2 : (connections.right ? 1 : 0) | (connections.top ? 1 : 0) << 1 | (connections.topRight ? 1 : 0) << 2) : (left ? (connections.left ? 1 : 0) | (connections.bottom ? 1 : 0) << 1 | (connections.bottomLeft ? 1 : 0) << 2 : (connections.right ? 1 : 0) | (connections.bottom ? 1 : 0) << 1 | (connections.bottomRight ? 1 : 0) << 2);
        return CORNER_SPRITE_INDICES[index];
    }

    private static void remapUVFullSprite(MutableQuad quad, int tileIndex, ConnectingTextureSprite sprite) {
        for (int i = 0; i < 4; ++i) {
            float width = sprite.getU1() - sprite.getU0();
            float u = sprite.getStartU() + quad.u(i) - sprite.getU0() + width * (float)tileIndex;
            quad.uv(i, u, quad.v(i));
        }
    }

    private static double vertexDistance(MutableQuad quad, int v1, int v2) {
        double xDiff = quad.x(v2) - quad.x(v1);
        double yDiff = quad.y(v2) - quad.y(v1);
        double zDiff = quad.z(v2) - quad.z(v1);
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    @Override
    public boolean processItemQuad(int quadIndex, MutableQuad quad, ConnectingTextureSprite sprite) {
        return quadIndex == 0;
    }
}

