/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;

public class ConnectingModelQuad
extends BaseModelQuad {
    private final ConnectionPredicate predicate;
    private final ConnectingTextureLayout layout;

    public ConnectingModelQuad(BakedQuad bakedQuad, Direction cullDirection, Integer lightEmission, ConnectionPredicate connectionPredicate) {
        super(bakedQuad, cullDirection, lightEmission);
        TextureAtlasSprite sprite = bakedQuad.getSprite();
        if (sprite instanceof ConnectingTextureSprite && ((ConnectingTextureSprite)sprite).data() != null) {
            ConnectingTextureData data = ((ConnectingTextureSprite)sprite).data();
            this.predicate = connectionPredicate;
            this.layout = data.getLayout();
        } else {
            this.predicate = null;
            this.layout = null;
        }
    }

    public ConnectionPredicate connectionPredicate() {
        return this.predicate;
    }

    public ConnectingTextureLayout getLayout() {
        return this.layout;
    }

    public boolean hasConnectingTexture() {
        return this.layout != null;
    }
}

