/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.fusion.entity.EntityRenderTypeHelper;
import com.supermartijn642.fusion.entity.VanillaModelLayerProperties;
import com.supermartijn642.fusion.entity.model.EntityLayerProperties;
import com.supermartijn642.fusion.entity.model.SubModelPart;
import com.supermartijn642.fusion.extensions.BufferSourceExtension;
import com.supermartijn642.fusion.extensions.EntityExtension;
import com.supermartijn642.fusion.util.Triple;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class FusionModelPart
extends SubModelPart {
    private final int layerIndex;
    private final ModelPart original;
    private VanillaModelLayerProperties vanillaProperties;
    private EntityLayerProperties properties;
    private boolean ready;
    private MultiBufferSource bufferSource;
    private ResourceLocation currentTexture;
    private Float currentScaling;
    private RenderType adjustedRenderType;

    public FusionModelPart(int layerIndex, ModelPart original) {
        super(null);
        this.mainPart = this;
        this.layerIndex = layerIndex;
        this.original = original;
    }

    public void setProperties(EntityLayerProperties properties, VanillaModelLayerProperties vanillaProperties) {
        this.properties = properties;
        this.vanillaProperties = vanillaProperties;
        if (properties == null) {
            this.mirror(this.original);
        }
    }

    public void setup(Entity entity, MultiBufferSource bufferSource) {
        if (this.properties == null) {
            return;
        }
        this.bufferSource = bufferSource;
        if (((EntityExtension)entity).shouldFusionRecomputeModel(this.layerIndex)) {
            Triple<ModelPart, ResourceLocation, Float> model = this.properties.chooseModel(entity);
            ((EntityExtension)entity).setFusionModel(this.layerIndex, model);
        }
        Triple<ModelPart, ResourceLocation, Float> modelChoice = ((EntityExtension)entity).getFusionModel(this.layerIndex);
        ModelPart currentModel = modelChoice.left();
        this.currentTexture = modelChoice.middle();
        this.currentScaling = modelChoice.right();
        FusionModelPart.resetPose(currentModel);
        this.mirror(currentModel);
        this.ready = true;
    }

    public void clear() {
        if (this.properties == null) {
            return;
        }
        this.bufferSource = null;
        this.currentTexture = null;
        this.currentScaling = null;
        this.adjustedRenderType = null;
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, int k) {
        this.renderPart(this, poseStack, vertexConsumer, i, j, k);
    }

    public void renderPart(SubModelPart part, PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, int k) {
        if (!this.visible) {
            return;
        }
        if (!this.ready) {
            if (part == this) {
                this.original.render(poseStack, vertexConsumer, i, j, k);
            }
            return;
        }
        if (this.bufferSource != null && this.currentTexture != null) {
            vertexConsumer = this.adjustTexture(vertexConsumer, this.bufferSource);
        }
        poseStack.pushPose();
        this.vanillaProperties.transform(poseStack);
        if (this.currentScaling != null) {
            poseStack.scale(this.currentScaling.floatValue(), this.currentScaling.floatValue(), this.currentScaling.floatValue());
        }
        part.renderInternal(poseStack, vertexConsumer, i, j, k);
        poseStack.popPose();
    }

    private static void resetPose(ModelPart part) {
        part.resetPose();
        part.children.values().forEach(FusionModelPart::resetPose);
    }

    private VertexConsumer adjustTexture(VertexConsumer buffer, MultiBufferSource bufferSource) {
        if (!(bufferSource instanceof BufferSourceExtension)) {
            return buffer;
        }
        RenderType renderType = ((BufferSourceExtension)bufferSource).fusionGetLastRenderType();
        if (this.adjustedRenderType != null && this.adjustedRenderType == renderType) {
            return bufferSource.getBuffer(renderType);
        }
        if (!(renderType instanceof RenderType.CompositeRenderType)) {
            return buffer;
        }
        RenderStateShard.EmptyTextureStateShard textureState = ((RenderType.CompositeRenderType)renderType).state.textureState;
        if (!(textureState instanceof RenderStateShard.TextureStateShard)) {
            return buffer;
        }
        ResourceLocation texture = ((RenderStateShard.TextureStateShard)textureState).texture.orElse(null);
        if (this.currentTexture.equals((Object)texture)) {
            return buffer;
        }
        if ((renderType = EntityRenderTypeHelper.getRenderTypeWithTexture(renderType, this.currentTexture)) == null) {
            return buffer;
        }
        this.adjustedRenderType = renderType;
        return bufferSource.getBuffer(renderType);
    }
}

