/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.generation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.world.content.registries.WorldStructures;

public class CaveGeyserPiece
extends StructurePiece {
    private static final String NBT_KEY_BLOCK = "block_well";
    private static final String NBT_KEY_RADIUS = "clearing_radius";
    private static final String NBT_KEY_HEIGHT = "clearing_height";
    private final BlockState blockWell;
    private final BlockState surrounding;
    private final float clearingRadius;
    private final float clearingHeight;
    private static final Vec3i[] offsets = new Vec3i[]{new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, -1)};

    private static BoundingBox snapCenterBottom(BlockPos basePos, int radius, int height) {
        BlockPos centerBottom = new BlockPos((basePos.getX() & 0xFFFFFFF0) + 8, basePos.getY(), (basePos.getZ() & 0xFFFFFFF0) + 8);
        return new BoundingBox(centerBottom.getX() - radius, centerBottom.getY(), centerBottom.getZ() - radius, centerBottom.getX() + radius, centerBottom.getY() + height, centerBottom.getZ() + radius);
    }

    public CaveGeyserPiece(BlockPos nodePos, BlockState blockWell, float radius, float height) {
        super((StructurePieceType)WorldStructures.CaveNodePiece.value(), 0, CaveGeyserPiece.snapCenterBottom(nodePos, Math.max(Mth.ceil((float)(radius - 6.0f)), 0), Math.max(Mth.ceil((float)(height - 5.0f)), 0)));
        this.blockWell = blockWell;
        this.surrounding = Blocks.DRIPSTONE_BLOCK.defaultBlockState();
        this.clearingRadius = radius;
        this.clearingHeight = radius;
    }

    public CaveGeyserPiece(StructurePieceSerializationContext serializationContext, CompoundTag tag) {
        super((StructurePieceType)WorldStructures.CaveNodePiece.value(), tag);
        this.blockWell = NbtUtils.readBlockState((HolderGetter)serializationContext.registryAccess().lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound(NBT_KEY_BLOCK));
        this.surrounding = Blocks.DRIPSTONE_BLOCK.defaultBlockState();
        this.clearingRadius = tag.getFloat(NBT_KEY_RADIUS);
        this.clearingHeight = tag.getFloat(NBT_KEY_HEIGHT);
    }

    protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext serializationContext, CompoundTag tag) {
        tag.put(NBT_KEY_BLOCK, (Tag)NbtUtils.writeBlockState((BlockState)this.blockWell));
    }

    public void postProcess(@NotNull WorldGenLevel level, @NotNull StructureManager manager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, BoundingBox chunkBox, @NotNull ChunkPos chunkPos, @NotNull BlockPos startBottomCenter) {
        if (!chunkBox.isInside((Vec3i)startBottomCenter)) {
            return;
        }
        BlockPos placementPos = CaveGeyserPiece.verifyFloor(level, startBottomCenter);
        this.boundingBox = CaveGeyserPiece.snapCenterBottom(placementPos, this.boundingBox.getXSpan() + this.boundingBox.getZSpan() >> 2, this.boundingBox.getYSpan());
        BlockState waterFill = CaveGeyserPiece.getWaterFiller(placementPos, generator.getSeaLevel());
        this.carveCavePocket(level, placementPos, waterFill);
        this.placeWellspring(level, placementPos, waterFill);
    }

    private void carveCavePocket(WorldGenLevel level, BlockPos placementPos, BlockState waterFill) {
        int yDelta = 1;
        while ((float)yDelta <= this.clearingHeight) {
            CaveGeyserPiece.carveBlock(level, placementPos.offset(0, yDelta, 0), waterFill);
            ++yDelta;
        }
        float radiusSq = this.clearingRadius * this.clearingRadius;
        int radiusFloored = Mth.floor((float)this.clearingRadius);
        int heightFloored = Mth.floor((float)this.clearingHeight);
        for (int basisX = radiusFloored; basisX >= 0; --basisX) {
            for (int basisZ = radiusFloored; basisZ >= 1; --basisZ) {
                int distSq = basisX * basisX + basisZ * basisZ;
                if (!((float)distSq <= radiusSq)) continue;
                float pinch = Math.max((float)distSq - radiusSq * 0.525f, 0.0f) * 0.5f;
                int heightMin = Math.max(1 + Mth.ceil((float)pinch), 1);
                int heightMax = Math.min(heightFloored + Mth.floor((float)(-pinch)), heightFloored);
                for (int yDelta2 = heightMin; yDelta2 <= heightMax; ++yDelta2) {
                    CaveGeyserPiece.carveBlock(level, placementPos.offset(basisX, yDelta2, basisZ), waterFill);
                    CaveGeyserPiece.carveBlock(level, placementPos.offset(-basisZ, yDelta2, basisX), waterFill);
                    CaveGeyserPiece.carveBlock(level, placementPos.offset(-basisX, yDelta2, -basisZ), waterFill);
                    CaveGeyserPiece.carveBlock(level, placementPos.offset(basisZ, yDelta2, -basisX), waterFill);
                }
            }
        }
        CaveGeyserPiece.carveBlock(level, placementPos, waterFill);
    }

    private static BlockState getWaterFiller(BlockPos placementPos, int seaLevel) {
        if (placementPos.getY() > seaLevel - 5) {
            return Blocks.DIRT.defaultBlockState();
        }
        if (placementPos.getY() > seaLevel - 63) {
            return Blocks.STONE.defaultBlockState();
        }
        return Blocks.DEEPSLATE.defaultBlockState();
    }

    private static BlockPos verifyFloor(WorldGenLevel level, BlockPos startBottomCenter) {
        if (!level.getBlockState(startBottomCenter).canBeReplaced() && level.getBlockState(startBottomCenter.above()).isAir()) {
            return startBottomCenter;
        }
        return CaveGeyserPiece.adjustForFloor(level, startBottomCenter, level.getMinBuildHeight() + 8, level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, startBottomCenter.getX(), startBottomCenter.getZ()) - 16);
    }

    private static void carveBlock(WorldGenLevel level, BlockPos center, BlockState waterFill) {
        for (Direction dir : Direction.values()) {
            BlockPos posRelative = center.relative(dir);
            if (level.getBlockState(posRelative).getFluidState().isEmpty()) continue;
            level.setBlock(posRelative, waterFill, 2);
        }
        level.setBlock(center, Blocks.CAVE_AIR.defaultBlockState(), 2);
    }

    private void placeWellspring(WorldGenLevel level, BlockPos placementPos, BlockState waterFill) {
        for (Vec3i offset : offsets) {
            BlockPos offsetPos = placementPos.offset(offset);
            level.setBlock(offsetPos, this.surrounding, 2);
            level.getChunk(offsetPos).markPosForPostprocessing(offsetPos);
        }
        level.setBlock(placementPos, this.blockWell, 2);
        level.getChunk(placementPos).markPosForPostprocessing(placementPos);
        for (Direction sideFace : Direction.Plane.HORIZONTAL) {
            BlockPos sidewaysPos = placementPos.relative(sideFace);
            if (!level.getBlockState(sidewaysPos).canBeReplaced()) continue;
            level.setBlock(sidewaysPos, waterFill, 2);
        }
    }

    private static BlockPos adjustForFloor(WorldGenLevel level, BlockPos defaultPosY, int minY, int maxY) {
        boolean isFragileBelow = level.getBlockState(defaultPosY.atY(maxY)).canBeReplaced();
        for (int findFloorY = minY + 1; findFloorY < defaultPosY.getY(); ++findFloorY) {
            BlockPos newPlacement = defaultPosY.atY(findFloorY);
            boolean isBlockFragile = level.getBlockState(newPlacement).canBeReplaced();
            if (isFragileBelow || !isBlockFragile) continue;
            return newPlacement.below();
        }
        return defaultPosY.atY(Mth.lerpInt((float)level.getRandom().nextFloat(), (int)minY, (int)maxY));
    }
}

