/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.ftbquestslangsplitter.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class LocaleArgument
implements ArgumentType<String> {
    private static final DynamicCommandExceptionType ERROR_INVALID_LOCALE = new DynamicCommandExceptionType(obj -> Component.translatableEscape((String)"ftbquestslangsplitter.commands.unsupported_locale", (Object[])new Object[]{obj}));

    public static LocaleArgument locale() {
        return new LocaleArgument();
    }

    public static String getLocale(CommandContext<CommandSourceStack> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String result = reader.readUnquotedString();
        if (Minecraft.getInstance().getLanguageManager().getLanguages().containsKey(result)) {
            return result;
        }
        throw ERROR_INVALID_LOCALE.create((Object)result);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!(context.getSource() instanceof SharedSuggestionProvider)) {
            return Suggestions.empty();
        }
        Set suggestion = Minecraft.getInstance().getLanguageManager().getLanguages().keySet();
        return SharedSuggestionProvider.suggest(suggestion, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return List.of("en_us", "pt_br", "ja_jp", "ru_ru");
    }
}

