/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import appeng.api.stacks.GenericStack;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import dan200.computercraft.api.lua.LuaTable;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.mekanism.Mekanism;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import net.minecraft.core.registries.BuiltInRegistries;

public abstract class GenericFilter<T> {
    private static final GenericFilter<?> EMPTY = new GenericFilter<Object>(){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean testAE(GenericStack genericStack) {
            return false;
        }

        @Override
        public boolean testRS(ResourceAmount resourceAmount) {
            return false;
        }

        @Override
        public boolean test(Object toTest) {
            return false;
        }
    };

    public static Pair<? extends GenericFilter<?>, String> parseGeneric(LuaTable<?, ?> rawFilter) {
        Object object;
        if (rawFilter.containsKey((Object)"type") && (object = rawFilter.get((Object)"type")) instanceof String) {
            String type = (String)object;
            if (type.equals("item")) {
                return ItemFilter.parse(rawFilter);
            }
            if (type.equals("fluid")) {
                return FluidFilter.parse(rawFilter);
            }
            if (type.equals("chemical") && APAddon.MEKANISM.isLoaded()) {
                return ChemicalFilter.parse(rawFilter);
            }
        }
        if (!rawFilter.containsKey((Object)"name")) {
            return Pair.of(GenericFilter.empty(), "NO_NAME_OR_TYPE");
        }
        String name = rawFilter.get((Object)"name").toString();
        if (ItemUtil.getRegistryEntry(name, BuiltInRegistries.ITEM) != null) {
            return ItemFilter.parse(rawFilter);
        }
        if (ItemUtil.getRegistryEntry(name, BuiltInRegistries.FLUID) != null) {
            return FluidFilter.parse(rawFilter);
        }
        if (APAddon.MEKANISM.isLoaded() && ItemUtil.getRegistryEntry(name, Mekanism.getChemicalRegistry()) != null) {
            return ChemicalFilter.parse(rawFilter);
        }
        return Pair.of(GenericFilter.empty(), "NO_VALID_FILTER_TYPE");
    }

    public abstract boolean isEmpty();

    public abstract boolean testAE(GenericStack var1);

    public abstract boolean testRS(ResourceAmount var1);

    public abstract boolean test(T var1);

    public static GenericFilter<?> empty() {
        return EMPTY;
    }
}

