/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.fakeplayer;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class FakePlayerProviderTurtle {
    private static final WeakHashMap<ITurtleAccess, APFakePlayer> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderTurtle() {
    }

    public static APFakePlayer getPlayer(ITurtleAccess turtle, GameProfile profile) {
        return registeredPlayers.computeIfAbsent(turtle, iTurtleAccess -> new APFakePlayer((ServerLevel)turtle.getLevel(), null, profile));
    }

    public static void load(APFakePlayer player, ITurtleAccess turtle) {
        int i;
        Direction direction = turtle.getDirection();
        player.setLevel(turtle.getLevel());
        BlockPos position = turtle.getPosition();
        player.moveTo((double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, direction.toYRot(), 0.0f);
        Inventory playerInventory = player.getInventory();
        playerInventory.selected = 0;
        Container turtleInventory = turtle.getInventory();
        int size = turtleInventory.getContainerSize();
        int largerSize = playerInventory.getContainerSize();
        playerInventory.selected = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            playerInventory.setItem(i, turtleInventory.getItem(i));
        }
        for (i = size; i < largerSize; ++i) {
            playerInventory.setItem(i, ItemStack.EMPTY);
        }
        ItemStack activeStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!activeStack.isEmpty()) {
            activeStack.getAttributeModifiers().forEach(EquipmentSlot.MAINHAND, (attr, modif) -> {
                AttributeInstance inst = player.getAttribute((Holder)attr);
                if (inst != null) {
                    inst.addOrUpdateTransientModifier(modif);
                }
            });
        }
    }

    public static void unload(APFakePlayer player, ITurtleAccess turtle) {
        int i;
        Inventory playerInventory = player.getInventory();
        playerInventory.selected = 0;
        ItemStack activeStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!activeStack.isEmpty()) {
            activeStack.getAttributeModifiers().forEach(EquipmentSlot.MAINHAND, (attr, modif) -> {
                AttributeInstance inst = player.getAttribute((Holder)attr);
                if (inst != null) {
                    inst.addOrUpdateTransientModifier(modif);
                }
            });
        }
        Container turtleInventory = turtle.getInventory();
        int size = turtleInventory.getContainerSize();
        int largerSize = playerInventory.getContainerSize();
        playerInventory.selected = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            turtleInventory.setItem(i, playerInventory.getItem(i));
            playerInventory.setItem(i, ItemStack.EMPTY);
        }
        for (i = size; i < largerSize; ++i) {
            ItemStack remaining = playerInventory.getItem(i);
            if (!remaining.isEmpty() && !(remaining = InventoryUtil.storeItemsFromOffset((Container)turtleInventory, (ItemStack)remaining, (int)0)).isEmpty()) {
                BlockPos position = turtle.getPosition();
                WorldUtil.dropItemStack((Level)turtle.getLevel(), (BlockPos)position, (Direction)turtle.getDirection().getOpposite(), (ItemStack)remaining);
            }
            playerInventory.setItem(i, ItemStack.EMPTY);
        }
    }

    public static <T> T withPlayer(ITurtleAccess turtle, Function<APFakePlayer, T> function) {
        APFakePlayer player = FakePlayerProviderTurtle.getPlayer(turtle, turtle.getOwningPlayer());
        FakePlayerProviderTurtle.load(player, turtle);
        T result = function.apply(player);
        FakePlayerProviderTurtle.unload(player, turtle);
        return result;
    }
}

