/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.fakeplayer;

import com.mojang.authlib.GameProfile;
import de.srendi.advancedperipherals.common.util.Pair;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class APFakePlayer
extends FakePlayer {
    public static final GameProfile PROFILE = new GameProfile(UUID.fromString("6e483f02-30db-4454-b612-3a167614b276"), "[advancedperipherals]");
    private static final Predicate<Entity> collidablePredicate = EntitySelector.NO_SPECTATORS;
    private final WeakReference<Entity> owner;
    private BlockPos digPosition;
    private Block digBlock;
    private float currentDamage = 0.0f;

    public APFakePlayer(ServerLevel world, Entity owner, GameProfile profile) {
        super(world, profile != null && StringUtils.isNotBlank((CharSequence)profile.getName()) ? profile : PROFILE);
        if (owner != null) {
            this.setCustomName(owner.getName());
            this.owner = new WeakReference<Entity>(owner);
        } else {
            this.owner = null;
        }
    }

    public void awardStat(@NotNull Stat<?> stat) {
        ServerPlayer player;
        MinecraftServer server = this.level().getServer();
        if (server != null && this.getGameProfile() != PROFILE && (player = server.getPlayerList().getPlayer(this.getUUID())) != null) {
            player.awardStat(stat);
        }
    }

    public boolean canAttack(@NotNull LivingEntity livingEntity) {
        return true;
    }

    public boolean isSilent() {
        return true;
    }

    public void setLevel(@NotNull Level level) {
        super.setLevel(level);
    }

    public void playSound(@NotNull SoundEvent soundIn, float volume, float pitch) {
    }

    private void setState(Block block, BlockPos pos) {
        if (this.digPosition != null) {
            this.gameMode.handleBlockBreakAction(this.digPosition, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.EAST, 320, 1);
        }
        this.digPosition = pos;
        this.digBlock = block;
        this.currentDamage = 0.0f;
    }

    public float getEyeHeight(@NotNull Pose pose) {
        return 0.0f;
    }

    public static <T> Function<APFakePlayer, T> wrapActionWithRot(float yaw, float pitch, Function<APFakePlayer, T> action) {
        return player -> player.doActionWithRot(yaw, pitch, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doActionWithRot(float yaw, float pitch, Function<APFakePlayer, T> action) {
        float oldRot = this.getYRot();
        this.setRot(oldRot + yaw, pitch);
        try {
            T t = action.apply(this);
            return t;
        }
        finally {
            this.setRot(oldRot, 0.0f);
        }
    }

    public static <T> Function<APFakePlayer, T> wrapActionWithShiftKey(boolean shift, Function<APFakePlayer, T> action) {
        return player -> player.doActionWithShiftKey(shift, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doActionWithShiftKey(boolean shift, Function<APFakePlayer, T> action) {
        boolean old = this.isShiftKeyDown();
        this.setShiftKeyDown(shift);
        try {
            T t = action.apply(this);
            return t;
        }
        finally {
            this.setShiftKeyDown(old);
        }
    }

    public Pair<Boolean, String> digBlock() {
        Level world = this.level();
        HitResult hit = this.findHit(true, false);
        if (hit.getType() == HitResult.Type.MISS) {
            return Pair.of(false, "Nothing to break");
        }
        BlockPos pos = ((BlockHitResult)hit).getBlockPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        ItemStack tool = this.getInventory().getSelected();
        if (tool.isEmpty()) {
            return Pair.of(false, "Cannot dig without tool");
        }
        if (block != this.digBlock || !pos.equals((Object)this.digPosition)) {
            this.setState(block, pos);
        }
        Vec3 look = this.getLookAngle();
        Direction direction = Direction.getNearest((double)look.x, (double)look.y, (double)look.z).getOpposite();
        if (world.isEmptyBlock(pos) || state.getBlock() instanceof LiquidBlock) {
            return Pair.of(false, "Nothing to dig here");
        }
        if (block == Blocks.BEDROCK || state.getDestroySpeed((BlockGetter)world, pos) <= -1.0f) {
            return Pair.of(false, "Unbreakable block detected");
        }
        if (!tool.isCorrectToolForDrops(state)) {
            return Pair.of(false, "Tool cannot mine this block");
        }
        ServerPlayerGameMode manager = this.gameMode;
        float breakSpeed = 0.5f * tool.getDestroySpeed(state) / state.getDestroySpeed((BlockGetter)world, pos) - 0.1f;
        for (int i = 0; i < 10; ++i) {
            this.currentDamage += breakSpeed;
            world.destroyBlockProgress(this.getId(), pos, i);
            if (!(this.currentDamage > 9.0f)) continue;
            world.playSound(null, pos, state.getSoundType().getHitSound(), SoundSource.NEUTRAL, 0.25f, 1.0f);
            manager.handleBlockBreakAction(pos, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, direction, 320, 1);
            manager.destroyBlock(pos);
            world.destroyBlockProgress(this.getId(), pos, -1);
            this.setState(null, null);
            break;
        }
        return Pair.of(true, "block");
    }

    public InteractionResult useOnBlock() {
        return this.use(true, false);
    }

    public InteractionResult useOnEntity() {
        return this.use(false, true);
    }

    public InteractionResult useOnFilteredEntity(Predicate<Entity> filter) {
        return this.use(false, true, filter);
    }

    public InteractionResult useOnSpecificEntity(@NotNull Entity entity, HitResult result) {
        InteractionResult simpleInteraction = this.interactOn(entity, InteractionHand.MAIN_HAND);
        if (simpleInteraction == InteractionResult.SUCCESS) {
            return simpleInteraction;
        }
        if (CommonHooks.onInteractEntityAt((Player)this, (Entity)entity, (Vec3)result.getLocation(), (InteractionHand)InteractionHand.MAIN_HAND) == InteractionResult.FAIL) {
            return InteractionResult.FAIL;
        }
        return entity.interactAt((Player)this, result.getLocation(), InteractionHand.MAIN_HAND);
    }

    public InteractionResult use(boolean skipEntity, boolean skipBlock) {
        return this.use(skipEntity, skipBlock, null);
    }

    public InteractionResult use(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        HitResult hit = this.findHit(skipEntity, skipBlock, entityFilter);
        if (hit instanceof BlockHitResult) {
            BlockItem blockItem;
            Block block;
            boolean usedOnBlock;
            BlockHitResult blockHit = (BlockHitResult)hit;
            ItemStack stack = this.getMainHandItem();
            BlockPos pos = blockHit.getBlockPos();
            PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)this, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)blockHit);
            if (event.isCanceled()) {
                return event.getCancellationResult();
            }
            boolean usedItem = event.getUseItem() != TriState.FALSE;
            boolean bl = usedOnBlock = event.getUseBlock() != TriState.FALSE;
            if (usedItem) {
                InteractionResult useType;
                InteractionResult result = stack.onItemUseFirst(new UseOnContext(this.level(), (Player)this, InteractionHand.MAIN_HAND, stack, blockHit));
                if (result != InteractionResult.PASS) {
                    return result;
                }
                boolean bypass = this.getMainHandItem().doesSneakBypassUse((LevelReader)this.level(), pos, (Player)this);
                if ((this.isShiftKeyDown() || bypass || usedOnBlock) && (useType = this.gameMode.useItemOn((ServerPlayer)this, this.level(), stack, InteractionHand.MAIN_HAND, blockHit)).consumesAction()) {
                    return useType;
                }
            }
            if (!stack.isEmpty() && this.getCooldowns().isOnCooldown(stack.getItem())) {
                return InteractionResult.PASS;
            }
            Item bypass = stack.getItem();
            if (bypass instanceof BlockItem && ((block = (blockItem = (BlockItem)bypass).getBlock()) instanceof CommandBlock || block instanceof StructureBlock)) {
                return InteractionResult.FAIL;
            }
            if (!usedItem && !usedOnBlock) {
                return InteractionResult.PASS;
            }
            ItemStack copyBeforeUse = stack.copy();
            InteractionResult result = stack.useOn(new UseOnContext(this.level(), (Player)this, InteractionHand.MAIN_HAND, stack, blockHit));
            if (stack.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)this, (ItemStack)copyBeforeUse, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            return result;
        }
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            return this.useOnSpecificEntity(entityHit.getEntity(), (HitResult)entityHit);
        }
        return InteractionResult.FAIL;
    }

    public HitResult findHit(boolean skipEntity, boolean skipBlock) {
        return this.findHit(skipEntity, skipBlock, null);
    }

    @NotNull
    public HitResult findHit(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        AttributeInstance reachAttribute = this.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (reachAttribute == null) {
            throw new IllegalArgumentException("How did this happened?");
        }
        double range = reachAttribute.getValue();
        Vec3 origin = new Vec3(this.getX(), this.getY(), this.getZ());
        Vec3 look = this.getLookAngle();
        Vec3 target = new Vec3(origin.x + look.x * range, origin.y + look.y * range, origin.z + look.z * range);
        ClipContext traceContext = new ClipContext(origin, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this);
        Vec3 directionVec = traceContext.getFrom().subtract(traceContext.getTo());
        Direction traceDirection = Direction.getNearest((double)directionVec.x, (double)directionVec.y, (double)directionVec.z);
        Object blockHit = skipBlock ? BlockHitResult.miss((Vec3)traceContext.getTo(), (Direction)traceDirection, (BlockPos)new BlockPos((int)traceContext.getTo().x, (int)traceContext.getTo().y, (int)traceContext.getTo().z)) : (HitResult)BlockGetter.traverseBlocks((Vec3)traceContext.getFrom(), (Vec3)traceContext.getTo(), (Object)traceContext, (rayTraceContext, blockPos) -> {
            if (this.level().isEmptyBlock(blockPos) || blockPos.equals((Object)this.blockPosition())) {
                return null;
            }
            BlockHitResult shaped = traceContext.getBlockShape(this.level().getBlockState(blockPos), (BlockGetter)this.level(), blockPos).clip(rayTraceContext.getFrom(), rayTraceContext.getTo(), blockPos);
            if (shaped != null && shaped.getType() != HitResult.Type.MISS) {
                return shaped;
            }
            return new BlockHitResult(new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), traceDirection, blockPos, false);
        }, rayTraceContext -> BlockHitResult.miss((Vec3)rayTraceContext.getTo(), (Direction)traceDirection, (BlockPos)new BlockPos((int)rayTraceContext.getTo().x, (int)rayTraceContext.getTo().y, (int)rayTraceContext.getTo().z)));
        if (skipEntity) {
            return blockHit;
        }
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(look.x * range, look.y * range, look.z * range).inflate(1.0), collidablePredicate);
        LivingEntity closestEntity = null;
        Vec3 closestVec = null;
        double closestDistance = blockHit.getType() == HitResult.Type.MISS ? range * range : this.distanceToSqr(blockHit.getLocation());
        for (Entity entityHit : entities) {
            Vec3 clipVec;
            if (!(entityHit instanceof LivingEntity)) continue;
            LivingEntity entity = (LivingEntity)entityHit;
            if (entityFilter != null && !entityFilter.test((Entity)entity) || entity.isPassenger()) continue;
            AABB box = entity.getBoundingBox();
            if (box.contains(origin)) {
                clipVec = origin;
            } else {
                clipVec = box.clip(origin, target).orElse(null);
                if (clipVec == null) continue;
            }
            double distance = origin.distanceToSqr(clipVec);
            if (distance <= 1.0E-6) {
                distance = 0.0;
            }
            if (distance > closestDistance || distance == closestDistance && closestEntity != null && closestEntity.getBoundingBox().getSize() >= box.getSize()) continue;
            closestEntity = entity;
            closestVec = clipVec;
            closestDistance = distance;
        }
        if (closestEntity != null) {
            return new EntityHitResult(closestEntity, closestVec);
        }
        return blockHit;
    }
}

