/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingSimulationRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.collect.ImmutableSet;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AECraftJob;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.MEBridgeEntityListener;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.MEBridgePeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.setup.Blocks;
import de.srendi.advancedperipherals.common.util.inventory.BasicCraftJob;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEBridgeEntity
extends PeripheralBlockEntity<MEBridgePeripheral>
implements IActionSource,
IActionHost,
IInWorldGridNodeHost,
IGridConnectedBlockEntity,
ICraftingSimulationRequester,
ICraftingRequester {
    private final List<AECraftJob> jobs = new CopyOnWriteArrayList<AECraftJob>();
    private boolean initialized = false;
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)MEBridgeEntityListener.INSTANCE);

    public MEBridgeEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.ME_BRIDGE.get(), pos, state);
        this.getMainNode().setExposedOnSides(this.getGridConnectableSides(null));
    }

    @Override
    @NotNull
    protected MEBridgePeripheral createPeripheral() {
        return new MEBridgePeripheral(this);
    }

    @Override
    public <T extends BlockEntity> void handleTick(Level level, BlockState state, BlockEntityType<T> type) {
        if (!this.level.isClientSide) {
            if (!this.initialized) {
                this.mainNode.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
                this.mainNode.setIdlePowerUsage((double)((Integer)APConfig.PERIPHERALS_CONFIG.meConsumption.get()).intValue());
                this.mainNode.setVisualRepresentation(new ItemStack((ItemLike)Blocks.ME_BRIDGE.get()));
                this.mainNode.setInWorldNode(true);
                this.mainNode.create(level, this.getBlockPos());
                this.getPeripheralOptional().ifPresent(peripheral -> peripheral.setNode(this.mainNode));
                this.initialized = true;
            }
            this.jobs.forEach(BasicCraftJob::tick);
            this.jobs.removeIf(BasicCraftJob::canBePurged);
        }
    }

    @NotNull
    public Optional<Player> player() {
        return Optional.empty();
    }

    @NotNull
    public Optional<IActionHost> machine() {
        return Optional.of(this);
    }

    @NotNull
    public <T> Optional<T> context(@NotNull Class<T> key) {
        return Optional.empty();
    }

    @Nullable
    public IGridNode getActionableNode() {
        return this.mainNode.getNode();
    }

    public void setRemoved() {
        super.setRemoved();
        this.mainNode.destroy();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.mainNode.destroy();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return super.getGridConnectableSides(orientation);
    }

    @Nullable
    public IGridNode getGridNode() {
        return super.getGridNode();
    }

    @Nullable
    public IGridNode getGridNode(@NotNull Direction dir) {
        return this.getActionableNode();
    }

    public void saveChanges() {
    }

    @NotNull
    public AECableType getCableConnectionType(@NotNull Direction dir) {
        return AECableType.SMART;
    }

    @Nullable
    public IActionSource getActionSource() {
        return this;
    }

    public void addJob(AECraftJob job) {
        this.jobs.add(job);
    }

    public List<AECraftJob> getJobs() {
        return this.jobs;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.jobs.stream().filter(BasicCraftJob::isCraftingStarted).map(AECraftJob::getJobLink).collect(Collectors.toCollection(ImmutableSet::of));
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable mode) {
        return 0L;
    }

    public void jobStateChange(ICraftingLink link) {
        this.jobs.stream().filter(BasicCraftJob::isCraftingStarted).filter(job -> job.getJobLink().getCraftingID().equals(link.getCraftingID())).forEach(AECraftJob::jobStateChanged);
    }
}

