/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemFluidHandler;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class RSFluidHandler
implements IStorageSystemFluidHandler {
    @NotNull
    private final Network network;
    private final StorageNetworkComponent component;

    public RSFluidHandler(@NotNull Network network) {
        this.network = network;
        this.component = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
    }

    public int fill(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        long inserted = this.component.insert((ResourceKey)VariantUtil.ofFluidStack((FluidStack)resource), (long)resource.getAmount(), action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        return (int)((long)resource.getAmount() - inserted);
    }

    @Override
    @NotNull
    public FluidStack drain(FluidFilter filter, IFluidHandler.FluidAction simulate) {
        AdvancedPeripherals.debug("Trying to extract fluid from filter: " + String.valueOf(filter));
        FluidResource fluid = RSApi.getFluid(this.network, filter);
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        long amountExtracted = this.component.extract((ResourceKey)fluid, (long)filter.getCount(), simulate == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        FluidStack extracted = VariantUtil.toFluidStack((FluidResource)fluid, (long)((int)amountExtracted));
        AdvancedPeripherals.debug("Extracted fluid: " + String.valueOf(extracted) + " from filter: " + String.valueOf(filter));
        return extracted;
    }
}

