/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.EnergyDetectorEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;

public class EnergyDetectorPeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<EnergyDetectorEntity>> {
    public static final String PERIPHERAL_TYPE = "energy_detector";

    public EnergyDetectorPeripheral(EnergyDetectorEntity tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<EnergyDetectorEntity>(tileEntity));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableEnergyDetector.get();
    }

    @LuaFunction(mainThread=true)
    public final int getTransferRateLimit() {
        return ((EnergyDetectorEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).storageProxy.getMaxTransferRate();
    }

    @LuaFunction(mainThread=true)
    public final void setTransferRateLimit(long transferRate) {
        transferRate = Math.max(0L, Math.min((long)((Integer)APConfig.PERIPHERALS_CONFIG.energyDetectorMaxFlow.get()).intValue(), transferRate));
        ((EnergyDetectorEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).storageProxy.setMaxTransferRate((int)transferRate);
    }

    @LuaFunction(mainThread=true)
    public final int getTransferRate() {
        return ((EnergyDetectorEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).transferRate;
    }
}

