/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.integrations;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.lib.peripherals.BlockIntegrationPeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class NoteBlockIntegration
extends BlockIntegrationPeripheral<NoteBlock> {
    public NoteBlockIntegration(Level world, BlockPos pos) {
        super(world, pos);
    }

    @NotNull
    public String getType() {
        return "noteBlock";
    }

    @LuaFunction(mainThread=true)
    public final int changeNote() {
        BlockState state = this.world.getBlockState(this.pos);
        int newNote = CommonHooks.onNoteChange((Level)this.world, (BlockPos)this.pos, (BlockState)state, (int)((Integer)state.getValue((Property)NoteBlock.NOTE)), (int)((Integer)((BlockState)state.cycle((Property)NoteBlock.NOTE)).getValue((Property)NoteBlock.NOTE)));
        if (newNote == -1) {
            return -1;
        }
        state = (BlockState)state.setValue((Property)NoteBlock.NOTE, (Comparable)Integer.valueOf(newNote));
        this.world.setBlock(this.pos, state, 3);
        return newNote;
    }

    @LuaFunction(mainThread=true)
    public final int changeNoteBy(int note) throws LuaException {
        BlockState state = this.world.getBlockState(this.pos);
        if (note < 0 || note > 24) {
            throw new LuaException("Note argument need to be in a range of 0 and 24");
        }
        state = (BlockState)state.setValue((Property)NoteBlock.NOTE, (Comparable)Integer.valueOf(note));
        this.world.setBlock(this.pos, state, 3);
        return note;
    }

    @LuaFunction(mainThread=true)
    public final int getNote() {
        BlockState state = this.world.getBlockState(this.pos);
        return (Integer)state.getValue((Property)NoteBlock.NOTE);
    }

    @LuaFunction(mainThread=true)
    public final void playNote() {
        BlockState state = this.world.getBlockState(this.pos);
        if (((NoteBlockInstrument)state.getValue((Property)NoteBlock.INSTRUMENT)).worksAboveNoteBlock() || this.world.getBlockState(this.pos.above()).isAir()) {
            this.world.blockEvent(this.pos, this.getBlock(), 0, 0);
            this.world.gameEvent(null, (Holder)GameEvent.NOTE_BLOCK_PLAY, this.pos);
        }
    }
}

